
#include <dds/DdsDcpsInfrastructureC.h>
#include <dds/DdsDcpsPublicationC.h>
#include <dds/DCPS/Marked_Default_Qos.h>
#include <dds/DCPS/Service_Participant.h>
#include <dds/DCPS/transport/framework/TheTransportFactory.h>
#include "MessengerTypeSupportImpl.h"
#include "DataReaderListenerImpl.h"
#include <ace/Arg_Shifter.h>
#include "Runnable.h"
#include "DDSGateway.h"


void GetArgs(int argc, char *argv[],
	std::string &sname, std::string &secretcookie, int &port) {
		ACE_Arg_Shifter arg_shifter(argc, argv);
		while (arg_shifter.is_anything_left()) {
			const ACE_TCHAR *currentArg = 0;
			if ((currentArg = arg_shifter.get_the_parameter(ACE_TEXT("-sname"))) != 0) {
				sname = currentArg;
				arg_shifter.consume_arg();
			}
			else if ((currentArg = arg_shifter.get_the_parameter(ACE_TEXT("-setcookie"))) != 0) {
				secretcookie = currentArg;
				arg_shifter.consume_arg();
			}
			else if ((currentArg = arg_shifter.get_the_parameter(ACE_TEXT("-port"))) != 0) {
				port = ACE_OS::atoi(currentArg);
				arg_shifter.consume_arg();
			}
			else
				arg_shifter.ignore_arg();
		}	
}




int ACE_TMAIN(int argc, ACE_TCHAR *argv[]) {
	try {
		std::string sname("alice"), secretcookie("secretcookie");
		int port = 8001;
		GetArgs(argc, argv, sname, secretcookie, port);

		DDS::DomainParticipantFactory_var dpf =
			TheParticipantFactoryWithArgs(argc, argv);

		// create domain participant
		DDS::DomainParticipant_var participant =
			dpf->create_participant(42,
			PARTICIPANT_QOS_DEFAULT,
			0,
			OpenDDS::DCPS::DEFAULT_STATUS_MASK);

		if (0 == participant) 
			throw MyException("create_participant failed");


		// register type
		Messenger::MessageTypeSupport_var ts =
			new Messenger::MessageTypeSupportImpl();

		if (ts->register_type(participant.in(), "") != DDS::RETCODE_OK) 
			throw MyException("reigster_type failed");


		// create topic
		CORBA::String_var type_name = ts->get_type_name();
		DDS::Topic_var topic =
			participant->create_topic("MyTopic",
			type_name.in(),
			TOPIC_QOS_DEFAULT,
			0,
			OpenDDS::DCPS::DEFAULT_STATUS_MASK);

		if (0 == topic) 
			throw MyException("create_topic failed");


		// create publisher
		DDS::Publisher_var publisher =
			participant->create_publisher(PUBLISHER_QOS_DEFAULT,
			0,
			OpenDDS::DCPS::DEFAULT_STATUS_MASK);

		if (0 == publisher) 
			throw MyException("create_publisher failed");

		
		// create subscriber
		DDS::Subscriber_var subscriber =
			participant->create_subscriber(SUBSCRIBER_QOS_DEFAULT,
			0,
			OpenDDS::DCPS::DEFAULT_STATUS_MASK);

		if (0 == subscriber) 
			throw MyException("create_subscriber failed");


		// create and attach the transport
		OpenDDS::DCPS::TransportImpl_rch transport_impl =
			TheTransportFactory->create_transport_impl(OpenDDS::DCPS::DEFAULT_SIMPLE_TCP_ID,
			OpenDDS::DCPS::AUTO_CONFIG);

		if (transport_impl->attach(publisher.in()) != OpenDDS::DCPS::ATTACH_OK)
			throw MyException("transport creation for the publisher failed");

		if (transport_impl->attach(subscriber.in()) != OpenDDS::DCPS::ATTACH_OK)
			throw MyException("transport creation for the subscriber failed");


		// create and narrow datawriter
		DDS::DataWriter_var writer =
			publisher->create_datawriter(topic.in(),
			DATAWRITER_QOS_DEFAULT,
			DDS::DataWriterListener::_nil(),
			OpenDDS::DCPS::DEFAULT_STATUS_MASK);

		if (0 == writer) 
			throw MyException("create_datawriter failed");

		Messenger::MessageDataWriter_var message_writer =
			Messenger::MessageDataWriter::_narrow(writer.in());

		if (0 == message_writer) 
			throw MyException("writer _narrow failed");


		// create a common message queue
		MessageQueue<MessageType> messageQueue;


		// create and narrow datareader, assigning listener
		DDS::DataReaderListener_var listener(new DataReaderListenerImpl(messageQueue));

		DDS::DataReader_var reader =
			subscriber->create_datareader(topic.in(),
			DATAREADER_QOS_DEFAULT,
			listener.in(),
			OpenDDS::DCPS::DEFAULT_STATUS_MASK);

		if (0 == reader) 
			throw MyException("create_datareader failed");


		// run the Erlang node and wait for it to terminate
		Runner r(new DDSGateway(sname, secretcookie, port, message_writer.in(), messageQueue));
		r.Start();
		r.Wait();

		// clean up
		participant->delete_contained_entities();
		dpf->delete_participant(participant.in());

		TheTransportFactory->release();
		TheServiceParticipant->shutdown();

	} catch (const CORBA::Exception& e) {
		e._tao_print_exception("Exception caught in main():");
		return -1;
	} catch (const std::exception& e) {
		std::cerr << "Exception caught in main(): " << e.what() << std::endl;
		return -1;
	}

	return 0; 
}

