eval '(exit $?0)' && eval 'exec perl -S $0 ${1+"$@"}'
    & eval 'exec perl -S $0 $argv:q'
    if 0;
 
use strict;
    
use Env '$ACE_ROOT';
use lib "$ACE_ROOT/bin";
use PerlACE::Run_Test;


sub start_server {
    # obtain the arguments
    my $server_path = shift;
    my $server_cmdline = shift;
    my $ior_filename = shift;
  
    # remove the file containing the IOR if it currently exists
    my $ior = PerlACE::LocalFile($ior_filename);
    unlink $ior;
    
    # start the client with output redirected to a file
    my $server_output_file = "server_output.data";
    unlink $server_output_file;
    open (OLDOUT, ">&STDOUT");
    open (STDOUT, ">$server_output_file") or die "can't redirect stdout: $!";
    open (OLDERR, ">&STDERR");
    open (STDERR, ">&STDOUT") or die "can't redirect stderror: $!";
    
    my $server_process = new PerlACE::Process($server_path, $server_cmdline);
    # print $server_process->CommandLine() . "\n";
    $server_process->Spawn();
    
    close (STDERR);
    close (STDOUT);
    open (STDOUT, ">&OLDOUT");
    open (STDERR, ">&OLDERR");
    
    # wait for the IOR to be written to the file
    if (PerlACE::waitforfile_timed($ior, $PerlACE::wait_interval_for_process_creation) == -1) {
        print STDERR "ERROR: cannot find file <$ior>\n";
        $server_process->Kill();
        unlink $ior;
        exit 1;
    }     
   
    unlink $server_output_file;
  
    return ($ior, $server_process);
}


sub run_test {
    # obtain the arguments
    my $client_path = shift;
    my $client_cmdline = shift;
    my $ior_filename = shift;
    my $iorarg = shift;
    my $addarg = shift;
  
    # generate random numbers from 1 to 100 to add
    my $x = int(rand(100)) + 1;
    my $y = int(rand(100)) + 1;
    my $expected_sum = $x + $y;
    print "  $x+$y => Expected: $expected_sum  ";
     
    my $client_cmd = $client_cmdline . " $iorarg $ior_filename $addarg $x $y";
    #print $client_cmd . "\n";
    
    # start the client with output redirected to a file
    my $client_output_file = "client_output.data";
    unlink $client_output_file;
    open (OLDOUT, ">&STDOUT");
    open (STDOUT, ">$client_output_file") or die "can't redirect stdout: $!";
    open (OLDERR, ">&STDERR");
    open (STDERR, ">&STDOUT") or die "can't redirect stderror: $!";
    
    my $client = new PerlACE::Process($client_path, $client_cmd);
    $client->Spawn();
    my $client_return = $client->WaitKill(15);
    
    close (STDERR);
    close (STDOUT);
    open (STDOUT, ">&OLDOUT");
    open (STDERR, ">&OLDERR");
    
    # find the result
    open(CLIENT_OUTPUT_FILE, $client_output_file);
    my @lines=<CLIENT_OUTPUT_FILE>;
    close(CLIENT_OUTPUT_FILE);
    
    my $pattern = 'Sum: (\d+)';  # $1 is "Sum: nnn", $2 is "nnn"
    my $match_found = 0;
    my $line;
    foreach $line (@lines) {
        if ($line =~ m/($pattern)/) {
            print "Actual: $2";
            if ($2 == $expected_sum) {
                $match_found = 1;
                last;
            }
        }       
    }
    
    if ($match_found) {
        print "  => success\n";
    }
    else {
        print "  => failure\n";   
    }
    
    # clean-up
    #unlink $client_output_file;
    
    if ($client_return != 0) {
        print STDERR "ERROR: Client returned <$client_return>\n";
        exit 1 ;
    }
}




# retrieve info needed to execute JacORB
sub jacorb_args {
    # add the locations of the JacORB client and server to the classpath
    use Env '$CLASSPATH';
    my $classpath = "$CLASSPATH;../Java/IDL;../Java/Server;../Java/Client";

    # retrieve the location of JacORB
    use Env '$JACORB_HOME';
    my $jacorb_home = "$JACORB_HOME";

    # jaco.bat is really "javac $jaco_args", so rebuild the arguments here
    my $jaco_args = "-Djava.endorsed.dirs=$jacorb_home/lib -Djacorb.home=$jacorb_home "
        . "-Dorg.omg.CORBA.ORBClass=org.jacorb.orb.ORB "
        . "-Dorg.omg.CORBA.ORBSingletonClass=org.jacorb.orb.ORBSingleton -classpath $classpath ";

    # locate Java
    use Env '$JAVA_HOME';
    my $java_path = "$JAVA_HOME/bin/java";
    
    # suppress JacORB logging
    my $jacorb_args = $jaco_args . " -Djacorb.log.default.verbosity=0 ";

    return ($java_path, $jacorb_args);
}


# locate Java and startup arguments
my ($java_path, $jacorb_args);
($java_path, $jacorb_args) = jacorb_args();

# locate Perl
use Env '$PERL_ROOT';
my $perl_path = "$PERL_ROOT/bin/perl";

# locate Erlang
use Env '$ERL_ROOT';
my $erl_path = "$ERL_ROOT/bin/erl";

# servers to execute
my @servers = (
    { product => "TAO", 
      path => "../CPP/server/server", 
      cmdline => "-ior cpp.ior", 
      ior_file => "cpp.ior" 
    },
    { product => "orber",
      path => $erl_path,
      cmdline => "-pa ../Erlang -noshell -run crb server_test erlang.ior",
      ior_file => "erlang.ior"
    }  
#    { product => "JacORB", 
#      path => $java_path, 
#      cmdline => "$jacorb_args Server -ior java.ior", 
#      ior_file => "java.ior" 
#    },
#    { product => "opalORB", 
#      path => $perl_path, 
#      cmdline => 
#          "-I../Perl/server -I../Perl/IDL" .
#          " ../Perl/server/server.pl -ior perl.ior", 
#      ior_file => "perl.ior" 
#    },
#    { product => "IIOP.NET", 
#      path => "../CS/server/Debug/server", 
#      cmdline => "-ior cs.ior", 
#      ior_file => "cs.ior" 
#    }
);

# clients to execute
my @clients = (
    { product => "TAO", path => "../CPP/client/client", cmdline => "" },
    { product => "orber", path => $erl_path, cmdline => "-pa ../Erlang -noshell -run crb client_test", iorarg => "ior", addarg => "add" }
#    { product => "JacORB", path => $java_path, cmdline => "$jacorb_args Client" },
#    { product => "opalORB", path => $perl_path, cmdline => "-I../Perl/client -I../Perl/IDL ../Perl/client/client.pl" },
#    { product => "IIOP.NET", path => "../CS/client/Debug/client", cmdline => "" }
);


# start servers
my $num_servers = scalar(@servers);
my $i;
for ($i=0; $i<$num_servers; $i++) {
    print "Starting " . $servers[$i]{'product'} . " server\n";
    my ($ior, $process);
    ($ior, $process) = start_server($servers[$i]{'path'}, $servers[$i]{'cmdline'}, $servers[$i]{'ior_file'}); 
    $servers[$i]{'ior'} = $ior;
    $servers[$i]{'process'} = $process;
}

# run tests
my $num_clients = scalar(@clients);
my $j;
for ($i=0; $i<$num_servers; $i++) {
    for ($j=0; $j<$num_clients; $j++) {
        print "Running test: " . $servers[$i]{'product'} . " server, " . $clients[$j]{'product'} . " client\n";
        
        my ($iorarg, $addarg) = ("-ior", "-add");
    	$iorarg = $clients[$j]{'iorarg'} if $clients[$j]{'iorarg'};
    	$addarg = $clients[$j]{'addarg'} if $clients[$j]{'addarg'};
        run_test($clients[$j]{'path'}, $clients[$j]{'cmdline'}, $servers[$i]{'ior'}, $iorarg, $addarg);
    }
}

# shut down servers
for ($i=0; $i<$num_servers; $i++) {
    print "Stopping " . $servers[$i]{'product'} . " server\n";
    $servers[$i]{'process'}->Kill();
    unlink $servers[$i]{'ior_file'};
}

exit 0;