#ifndef __ERLANGNODE_H__
#define __ERLANGNODE_H__

#include "XBuff.h"
#include "Runnable.h"

class ErlangNode : public Runnable {
protected:
	std::string _shortName;
	std::string _secretCookie;
	int _port;
	int _fd;

protected:
	virtual bool OnMessage(erlang_pid /*from*/, XBuff & /*buff*/) { return true; }
	virtual bool OnIdle() { return true; }

	int Listen(int port) {
		int listen_fd;
		struct sockaddr_in addr;
		int on = 1;
		if ((listen_fd = socket(AF_INET, SOCK_STREAM, 0)) < 0)
			return (-1);
		setsockopt(listen_fd, SOL_SOCKET, SO_REUSEADDR, (char *)&on, sizeof(on));
		memset((void*) &addr, 0, (size_t) sizeof(addr));
		addr.sin_family = AF_INET;
		addr.sin_port = htons(port);
		addr.sin_addr.s_addr = htonl(INADDR_ANY);
		if (bind(listen_fd, (struct sockaddr*) &addr, sizeof(addr)) < 0)
			return (-1);
		listen(listen_fd, 5);
		return listen_fd;
	}


	void Send(erlang_pid to, XBuff &buff) {
		if (ei_send(_fd, &to, buff.get()->buff, buff.get()->index) < 0)
			throw EIException("ei_reg_send error failed", erl_errno);
	}


public:
	ErlangNode(std::string shortName, std::string secretCookie, int port) : 
	  _shortName(shortName), _secretCookie(secretCookie), _port(port) {}

	void *Svc() {

		try {
			ei_cnode ec;
			int n=0;
			if (ei_connect_init(&ec, _shortName.c_str(), _secretCookie.c_str(), n++) < 0) 
				throw EIException("ei_connect_init failed", erl_errno);

			int listen;
			if ((listen = Listen(_port)) <= 0)
				throw EIException("my_listen failed", errno);

			// be sure epmd is running first - if not, start erl with -sname and -setcookie args
			if (ei_publish(&ec, _port) == -1)
				throw EIException("erl_publish failed", erl_errno);

			ErlConnect conn;
			if ((_fd = ei_accept(&ec, listen, &conn)) == ERL_ERROR)
				throw EIException("erl_accept failed", erl_errno);

			while (true) {
				erlang_msg msg;
				XBuff buff(false);

				// http://www.erlang.org/doc/man/ei_connect.html#ei_receive_msg_tmo
				int rcv = ei_xreceive_msg_tmo(_fd, &msg, buff.get(), 10); // 10 ms
				if (rcv == ERL_MSG) {
					if ((msg.msgtype == ERL_REG_SEND) || (msg.msgtype == ERL_SEND)) {
						if (!OnMessage(msg.from, buff))
							break;
					}
					// ignore other message types
				}
				else if (rcv == ERL_ERROR) {
					if (!OnIdle())
						break;
				}
				// ignore other ei_xreceive_msg_tmo return values
			}
		}
		catch (std::exception& e) {
			std::cerr << "Exception: " << e.what() << std::endl;
		}
		return 0;
	}
};


#endif
