-module(crb).
-export([client_test/1, server_test/1]).


start_orber(Name) ->
	mnesia:start(),
	corba:orb_init([{domain, Name}, {orber_debug_level, 10}, {iiop_port, 0} ]),
	orber:install([node()], [{ifr_storage_type, ram_copies},
                             {nameservice_storage_type, ram_copies}]),
	orber:start().
	

client_test(["ior", IORFile, "add", Xp, Yp]) ->
	start_orber("client"),
	{X, _} = string:to_integer(Xp),
	{Y, _} = string:to_integer(Yp),
	oe_Math:oe_register(),
	Obj = corba:string_to_object(readIOR(IORFile)),
	Res = 'MathModule_Math':'Add'(Obj, X, Y),
	io:format("Sum: ~p~n", [Res]),
	init:stop().

server_test([IORFile]) ->
	start_orber("server"),
	Obj = 'MathModule_Math':oe_create(),
	writeIOR(IORFile, corba:object_to_string(Obj)).
	

readIOR(FileName) ->
    {ok, Binary} = file:read_file(FileName),
    erlang:binary_to_list(Binary).

writeIOR(FileName, IOR) ->
	{ok, FileDesc} = file:open(FileName, [write]),
	file:write(FileDesc, IOR),
	file:close(FileDesc).