#include "DDSGateway.h"

// to allow erlang_pid to be added to a std::set<T>
bool operator<(erlang_pid p1, erlang_pid p2) {
	int s = ACE_OS::strcmp(p1.node, p2.node);
	if (s!=0) 
		return s<0;
	if (p1.num != p2.num)
		return p1.num < p2.num;
	if (p1.serial != p2.serial)
		return p1.serial < p2.serial;
	return p1.creation < p2.creation;
}



bool DDSGateway::OnMessage(erlang_pid /*from*/, XBuff &buff) {
	// Process these messages:
	// { publish, { <string>, <long> } }
	// { subscribe, pid }
	// { unsubscribe, pid }
	// { shutdown }

	XBuffDecoder d = buff.GetDecoder();
	d.GetVersion();
	d.GetTupleHeader();
	std::string cmd = d.GetAtom();

	// on shutdown, exit
	if (cmd == "shutdown")
		return false;  

	// publish
	if (cmd == "publish") {
		d.GetTupleHeader();
		Messenger::Message message;
		message.msg = d.GetString().c_str();
		message.id = d.GetLong();

		DDS::ReturnCode_t err = _messageWriter->write(message, DDS::HANDLE_NIL);
		if (err!=DDS::RETCODE_OK)
			throw MyException("DDS write failed"); 
	}

	// subscribe
	if (cmd == "subscribe")
		_subscribers.insert(d.GetPID());

	// unsubscribe
	if (cmd == "unsubscribe")
		_subscribers.erase(d.GetPID());

	return true;
}

bool DDSGateway::OnIdle() { 
	// if there are no subscribers, discard pending messages and return
	if (_subscribers.empty()) {
		_messageQueue.clear();
		return true;
	}
	// otherwise, send each waiting message to all subscribers
	while (!_messageQueue.empty()) {
		MessageType m = _messageQueue.Remove();

		for (std::set<erlang_pid>::iterator subscriber = _subscribers.begin(); 
			subscriber!=_subscribers.end(); subscriber++) {

				XBuff rtn(true);
				XBuffEncoder e=rtn.GetEncoder();
				e.SetTupleHeader(3);
				e.SetAtom("message");
				e.SetString(m->msg.in());
				e.SetLong(m->id);
				Send(*subscriber, rtn);
		}
	}
	return true;
}


