#ifndef __MESSAGEQUEUE_H__
#define __MESSAGEQUEUE_H__

#include <list>

template<typename T>
class MessageQueue {
	std::list<T> _q;
	ACE_Thread_Mutex lock_;

public:
	void Insert(T t) {
		ACE_Guard<ACE_Thread_Mutex> guard(lock_);
		_q.push_back(t);
	}

	T Remove() {
		ACE_Guard<ACE_Thread_Mutex> guard(lock_);
		T front = _q.front();
		_q.pop_front();
		return front;
	}

	bool empty() {
		ACE_Guard<ACE_Thread_Mutex> guard(lock_);
		return _q.empty();
	}

	void clear() {
		ACE_Guard<ACE_Thread_Mutex> guard(lock_);
		return _q.clear();
	}
};

#endif