#include <dds/DdsDcpsInfrastructureC.h>
#include <dds/DdsDcpsSubscriptionC.h>
#include <dds/DCPS/Marked_Default_Qos.h>
#include <dds/DCPS/Service_Participant.h>
#include <dds/DCPS/WaitSet.h>
#include <dds/DCPS/transport/framework/TheTransportFactory.h>
#include "DataReaderListenerImpl.h"
#include "MessengerTypeSupportImpl.h"

class MyException : public std::exception {
	std::string _what;
public:
	MyException(const char *what) : _what(what) {}
	~MyException() throw() {}
	const char *what() { return _what.c_str(); }
};

int ACE_TMAIN(int argc, ACE_TCHAR *argv[]) {
	try {
		DDS::DomainParticipantFactory_var dpf =
			TheParticipantFactoryWithArgs(argc, argv);

		// create domain participant
		DDS::DomainParticipant_var participant =
			dpf->create_participant(42,
			PARTICIPANT_QOS_DEFAULT,
			0,
			OpenDDS::DCPS::DEFAULT_STATUS_MASK);

		if (0 == participant) 
			throw MyException("create_participant failed");


		// register type
		Messenger::MessageTypeSupport_var ts =
			new Messenger::MessageTypeSupportImpl();

		if (ts->register_type(participant.in(), "") != DDS::RETCODE_OK) 
			throw MyException("reigster_type failed");


		// create topic
		CORBA::String_var type_name = ts->get_type_name();
		DDS::Topic_var topic =
			participant->create_topic("MyTopic",
			type_name.in(),
			TOPIC_QOS_DEFAULT,
			0,
			OpenDDS::DCPS::DEFAULT_STATUS_MASK);

		if (0 == topic) 
			throw MyException("create_topic failed");


		// create subscriber
		DDS::Subscriber_var subscriber =
			participant->create_subscriber(SUBSCRIBER_QOS_DEFAULT,
			0,
			OpenDDS::DCPS::DEFAULT_STATUS_MASK);

		if (0 == subscriber) 
			throw MyException("create_subscriber failed");
		

		// create and attach the transport
		OpenDDS::DCPS::TransportImpl_rch transport_impl =
			TheTransportFactory->create_transport_impl(OpenDDS::DCPS::DEFAULT_SIMPLE_TCP_ID,
			OpenDDS::DCPS::AUTO_CONFIG);

		OpenDDS::DCPS::AttachStatus status = transport_impl->attach(subscriber.in());

		if (status != OpenDDS::DCPS::ATTACH_OK)
			throw MyException("transport creation failed");


		// create and narrow datareader, assigning listener
		DDS::DataReaderListener_var listener(new DataReaderListenerImpl);

		DDS::DataReader_var reader =
			subscriber->create_datareader(topic.in(),
			DATAREADER_QOS_DEFAULT,
			listener.in(),
			OpenDDS::DCPS::DEFAULT_STATUS_MASK);

		if (0 == reader) 
			throw MyException("create_datareader failed");

		Messenger::MessageDataReader_var message_reader =
			Messenger::MessageDataReader::_narrow(reader);

		if (0 == message_reader) 
			throw MyException("reader _narrow failed");


		// block until the publisher completes
		DDS::StatusCondition_var condition = reader->get_statuscondition();
		condition->set_enabled_statuses(DDS::SUBSCRIPTION_MATCHED_STATUS);

		DDS::WaitSet_var ws = new DDS::WaitSet;
		ws->attach_condition(condition);

		DDS::ConditionSeq conditions;
		DDS::SubscriptionMatchedStatus matches = { 0, 0, 0, 0, 0 };
		DDS::Duration_t timeout = { 300, 0 }; // 30 seconds

		do {
			if (ws->wait(conditions, timeout) != DDS::RETCODE_OK)
				throw MyException("wait failed");

			if (reader->get_subscription_matched_status(matches) != DDS::RETCODE_OK) 
				throw MyException("get_subscription_matched_status failed");
		} while (matches.current_count > 0);

		ws->detach_condition(condition);

		// clean up
		participant->delete_contained_entities();
		dpf->delete_participant(participant.in());

		TheTransportFactory->release();
		TheServiceParticipant->shutdown();

	} catch (const CORBA::Exception& e) {
		e._tao_print_exception("Exception caught in main():");
		return -1;
	} catch (const std::exception& e) {
		std::cerr << "Exception caught in main(): " << e.what() << std::endl;
		return -1;
	}

	return 0;
}