package tfd.sett.vertx;

import org.vertx.java.platform.Verticle;

public class MessagingExample extends Verticle {

    @Override
    public void start() {
        container.deployVerticle("tfd.sett.vertx.MessagingExample$Server");

        vertx.eventBus().registerHandler("message.handler", message -> {
            System.out.println("Handler 1 got a message = " + message.body());
        });

        vertx.eventBus().registerHandler("message.handler", message -> {
            System.out.println("Handler 2 got a message = " + message.body());
        });

        vertx.eventBus().registerHandler("message.handler", message -> {
            System.out.println("Handler 3 got a message = " + message.body());
        });
    }

    public static class Server extends Verticle {
        @Override
        public void start() {
            vertx.createHttpServer().requestHandler(httpServerRequest -> {
                if (httpServerRequest.params().contains("send")) {
                    vertx.eventBus().send("message.handler", httpServerRequest.params().get("send"));
                }
                if (httpServerRequest.params().contains("publish")) {
                    vertx.eventBus().publish("message.handler", httpServerRequest.params().get("publish"));
                }
                httpServerRequest.response().end("OK");
            }).listen(8080);
        }
    }
}
