package tfd.sett.vertx;

import org.vertx.java.core.net.NetServer;
import org.vertx.java.platform.Verticle;

public class NetServerExample extends Verticle {
    @Override
    public void start() {
        NetServer netServer = vertx.createNetServer();

        netServer.setSendBufferSize(2);

        netServer.connectHandler(sock -> {
            System.out.println("A client has connected!");

            sock.dataHandler(buffer -> {
                System.out.print(buffer.toString());
            });

            sock.closeHandler( aVoid -> {
                System.out.println("A client has closed");
            });
        });

        netServer.listen(8082);
    }
}
