package tfd.sett.vertx;

import org.vertx.java.platform.Verticle;

public class SharedDataExample extends Verticle {

    @Override
    public void start() {
        container.deployVerticle("tfd.sett.vertx.SharedData$Server1");
        container.deployVerticle("tfd.sett.vertx.SharedData$Server2");

    }

    public static class Server1 extends Verticle {
        @Override
        public void start() {
            vertx.createHttpServer().requestHandler(httpServerRequest -> {
                if (!"/favicon.ico".equals(httpServerRequest.path())) {
                    vertx.sharedData().getMap("map").put("server1", httpServerRequest.path());
                }
                Object server2Path = vertx.sharedData().getMap("map").get("server2");
                httpServerRequest.response().end(server2Path != null ? server2Path.toString() : "");
            }).listen(8080);
        }
    }

    public static class Server2 extends Verticle {
        @Override
        public void start() {
            vertx.createHttpServer().requestHandler(httpServerRequest -> {
                if (!"/favicon.ico".equals(httpServerRequest.path())) {
                    vertx.sharedData().getMap("map").put("server2", httpServerRequest.path());
                }
                Object server1Path = vertx.sharedData().getMap("map").get("server1");
                httpServerRequest.response().end(server1Path != null ? server1Path.toString() : "");
            }).listen(8081);
        }
    }
}
