package tfd.sett.vertx;

import org.vertx.java.core.Handler;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.platform.Verticle;

public class WorkerVerticleExample extends Verticle {
    @Override
    public void start() {
        container.deployVerticle("tfd.sett.vertx.WorkerVerticleExample$Server");
        container.deployWorkerVerticle("tfd.sett.vertx.WorkerVerticleExample$Worker");
    }

    public static class Server extends Verticle {
        @Override
        public void start() {
            vertx.createHttpServer().requestHandler(httpServerRequest -> {
                vertx.eventBus().send("worker.handler", httpServerRequest.path(), (Handler<Message<String>>) reply -> {
                    //System.out.printf("Handler Thread = %s\n", Thread.currentThread().getName());
                    httpServerRequest.response().end(reply.body());
                });
            }).listen(8080);
        }
    }

    public static class Worker extends Verticle {
        @Override
        public void start() {
            vertx.eventBus().registerHandler("worker.handler", message -> {
                //System.out.printf("Worker Thread = %s\n", Thread.currentThread().getName());
                try { Thread.sleep(1000); } catch (InterruptedException ex) { }
                message.reply("Hello World : " + message.body().toString());
            });
        }
    }
}
