package tfd.sett.vertx;

import org.vertx.java.core.Handler;
import org.vertx.java.core.http.HttpServer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.core.json.JsonArray;
import org.vertx.java.core.json.JsonObject;
import org.vertx.java.platform.Verticle;

public class ClientMessagingExample extends Verticle {
    @Override
    public void start() {
        HttpServer server = vertx.createHttpServer().requestHandler(
            new RouteMatcher()
                .get("/vertxbus-2.1.js", new FileHandler("/vertxbus-2.1.js"))
                .get("/favicon.ico", new FileHandler("/heart.ico"))
                .noMatch(new FileHandler("/clientevents.html"))
        );

        vertx.eventBus().registerHandler("message.handler", message -> {
            System.out.println("ClientMessagingExample got a message = " + message.body());
        });

        JsonArray permitted = new JsonArray().add(new JsonObject().putString("address", "message.handler"));
        vertx.createSockJSServer(server).bridge(new JsonObject().putString("prefix", "/eventbus"), permitted, permitted);
        server.listen(8080);
    }

    public static class FileHandler implements Handler<HttpServerRequest> {
        private final String file;

        public FileHandler(String file) {
            this.file = file;
        }

        @Override
        public void handle(HttpServerRequest httpServerRequest) {
            httpServerRequest.response().sendFile(this.getClass().getResource(file).getFile().replaceAll("^/[A-Z]:", ""));
        }
    }
}
