package tfd.sett.vertx;

import org.vertx.java.core.http.RouteMatcher;
import org.vertx.java.platform.Verticle;

public class RouteMatcherExample extends Verticle {
    @Override
    public void start() {
        RouteMatcher routeMatcher = new RouteMatcher();

        routeMatcher.get("/favicon.ico", req -> {
            req.response().sendFile(this.getClass().getResource("/heart.ico").getFile().replaceAll("^/[A-Z]:", ""));
        });

        routeMatcher.noMatch(req -> {
            req.response().end("Hello World");
        });

        vertx.createHttpServer().requestHandler(routeMatcher).listen(8080);
    }
}
