package main

import (
	"encoding/json"
	"firebase.google.com/go"
	"fmt"
	"google.golang.org/api/option"
	"google.golang.org/appengine"
	"google.golang.org/appengine/log"
	"google.golang.org/appengine/urlfetch"
	"io/ioutil"
	"net/http"
)

func main() {
	http.Handle("/static/", http.FileServer(http.Dir(".")))
	http.HandleFunc("/login", login_handler)
	http.HandleFunc("/data", data_handler)
	http.HandleFunc("/", handler)
	appengine.Main()
}

type LoginResult struct {
	WasSuccessful bool
	Message string
}

func login_handler(w http.ResponseWriter, r *http.Request) {
	ctx := appengine.NewContext(r)
	log.Debugf(ctx, "login called")
	
	result := LoginResult{false, ""}
	
	id_token := r.FormValue("Id")
	if id_token == "" {
		result.Message = "failed to get id_token"
		log.Debugf(ctx, result.Message)
	} else {
		log.Debugf(ctx, "id_token: %s", id_token)
		opt := option.WithCredentialsFile("./serviceAccountKey.json")
		if opt == nil {
			result.Message = "failed to get service account key"
			log.Debugf(ctx, result.Message)
		} else {
			app, err := firebase.NewApp(ctx, nil, opt)
			if err != nil {
				result.Message = fmt.Sprintf("error initializing app: %v\n", err)
				log.Debugf(ctx, result.Message)
			} else {		
				client, err := app.Auth(ctx)
				if err != nil {
					result.Message = fmt.Sprintf("error getting Auth client: %v\n", err)
					log.Debugf(ctx, result.Message)
				} else {
					token, err := client.VerifyIDToken(id_token)
					if err != nil {
						result.Message = fmt.Sprintf("error verifying ID token: %v\n", err)
						log.Debugf(ctx, result.Message)
					} else {
						// Simulate looking up user in a database...
						if (token.UID != "<YOUR_VALUE_HERE>") {
							result.Message = fmt.Sprintf("Invalid user - UID: %v\n", token.UID)
							log.Debugf(ctx, result.Message)
						} else {
							result.WasSuccessful = true
							result.Message = fmt.Sprintf("Verified UID: %v\n", token.UID)
							log.Debugf(ctx, result.Message)
						}
					}
				}
			}
		}
	}
	w.Header().Set("Content-Type", "application/json; charset=utf-8")
	json.NewEncoder(w).Encode(result)
}

func data_handler(w http.ResponseWriter, r *http.Request) {
	ctx := appengine.NewContext(r)
	log.Debugf(ctx, "data function called")
	log.Debugf(ctx, "method: %s", r.Method)
	if r.Method == http.MethodGet {
		log.Debugf(ctx, "GET - data")
		w.Header().Set("Content-Type", "application/json; charset=utf-8")

		client := urlfetch.Client(ctx)
		var url = ""
		if appengine.IsDevAppServer() {
			url = "http://localhost:8081/data"
		} else {
			url = "https://data-service-dot-sett-gae.appspot.com/data"
		}
		data_service_response, err := client.Get(url)
		if err != nil {
			log.Debugf(ctx, "Error calling data.  Error: %s", err.Error())
			http.Error(w, err.Error(), http.StatusInternalServerError)
			return
		}
		bodyBytes, err := ioutil.ReadAll(data_service_response.Body)
		bodyString := string(bodyBytes)
		log.Debugf(ctx, "Response: %s", bodyString)
		w.Write(bodyBytes)
	} else {
		log.Debugf(ctx, "invalid method")
		w.WriteHeader(http.StatusBadRequest)
	}
}

func handler(w http.ResponseWriter, r *http.Request) {
	ctx := appengine.NewContext(r)
	log.Debugf(ctx, "Serving index.html from handler function")
	http.ServeFile(w, r, "./static/html/index.html")
}
