package main

import (
	"encoding/json"
	"net/http"
	"google.golang.org/appengine"
	"google.golang.org/appengine/log"
)

type DataResponse struct {
	Status string
	Data string
}

func main() {
	http.HandleFunc("/data", data_handler)
	http.HandleFunc("/", error_handler)
	appengine.Main()
}

func data_handler(w http.ResponseWriter, r *http.Request) {
	ctx := appengine.NewContext(r)
	log.Debugf(ctx, "data function called")
	log.Debugf(ctx, "method: %s", r.Method)
	if r.Method == http.MethodGet {
		if !appengine.IsDevAppServer() {
			inbound_appid := r.Header.Get("X-Appengine-Inbound-Appid")
			log.Debugf(ctx, "inbound_appid: %s", inbound_appid)
			if inbound_appid != "<YOUR_VALUE_HERE>" {
				log.Debugf(ctx, "invalid inbound_appid")
				w.WriteHeader(http.StatusBadRequest)
				return
			}
		}
		w.Header().Set("Content-Type", "application/json; charset=utf-8")
		response := DataResponse{"success", "The data"}
		json.NewEncoder(w).Encode(response)
	} else {
		log.Debugf(ctx, "invalid method")
		w.WriteHeader(http.StatusBadRequest)
	}
}

func error_handler(w http.ResponseWriter, r *http.Request) {
	ctx := appengine.NewContext(r)
	log.Debugf(ctx, "unknown function called")
	w.WriteHeader(http.StatusBadRequest)
}
