requirejs.config({
	paths: {
		'jquery': 'https://code.jquery.com/jquery-3.2.1.min',
		'firebase': 'https://www.gstatic.com/firebasejs/4.10.1/firebase'
	},
	shim: {
		'firebase': {
			exports: 'firebase'
		}
	}
});

require(['jquery', 'firebase'], function(jquery, firebase) {
	$.get("./static/html/head.html", function(data) {
		$('head').html(data);
		initApp();
	});
});

function initApp() {
	initFirebase();
	
	firebase.auth().onAuthStateChanged(function(user) {
		if (user) {
			user.getIdToken().then(function(id_token) {
				$.post("login", { Id: id_token }, function() {
					console.log("onAuthStateChanged - verifying login");
				})
				.done(function(result) {
					console.log("onAuthStateChanged - done.  result.WasSuccessful: " + result.WasSuccessful);
					console.log("onAuthStateChanged - done.  result.Message: " + result.Message);
					if (result.WasSuccessful) {
						initUserDiv();
					}
					else {
						firebase.auth().signOut();
					}
				})
				.fail(function() {
					console.log("onAuthStateChanged - fail");
				})
				.always(function() {
					console.log("onAuthStateChanged - always");
				})
				.catch(function(error) {
					console.log("onAuthStateChanged - exception");
				});
			});
		}
		else {
			initHomeDiv();
		}
	});
	
	firebase.auth().getRedirectResult().then(function(result) {
		if (result.credential) {
			var token = result.credential.accessToken;
			console.log("getRedirectResult - token: " + token);
			if (result.user) {
				console.log("getRedirectResult - user name: " + result.user.displayName);
				console.log("getRedirectResult - user email: " + result.user.email);
			}
		}
	}).catch(function(error) {
		console.log("getRedirectResult - error code: " + error.code);
		console.log("getRedirectResult - error message: " + error.message);
	});
}

function initFirebase() {
	var config = {
		apiKey: "<YOUR_VALUE_HERE>",
		authDomain: "<YOUR_VALUE_HERE>",
		databaseURL: "<YOUR_VALUE_HERE>",
		projectId: "<YOUR_VALUE_HERE>",
		storageBucket: "<YOUR_VALUE_HERE>",
		messagingSenderId: "<YOUR_VALUE_HERE>"
	};
	
	firebase.initializeApp(config);
}

function initHomeDiv() {
	$('#userDiv').remove();
	$.get("./static/html/homeDiv.html", function(data) {
		$('body').html(data);
		$('#sign-in').click(function() {
			$('#sign-in').prop('disabled', true);
			var provider = new firebase.auth.GoogleAuthProvider();
			firebase.auth().signInWithRedirect(provider);
		});
	});
}

function initUserDiv() {
	$('#homeDiv').remove();
	$.get("./static/html/userDiv.html", function(data) {
		$('body').html(data);
		$('#sign-out').click(function() {
			$('#sign-out').prop('disabled', true);
			firebase.auth().signOut();
		});
	});
}