/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.jcd.cls;

import com.vladium.jcd.cls.IAttributeCollection;
import com.vladium.jcd.cls.IClassDefVisitor;
import com.vladium.jcd.cls.attribute.Attribute_info;
import com.vladium.jcd.cls.attribute.BridgeAttribute_info;
import com.vladium.jcd.cls.attribute.InnerClassesAttribute_info;
import com.vladium.jcd.cls.attribute.SyntheticAttribute_info;
import com.vladium.jcd.lib.UDataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

final class AttributeCollection
implements IAttributeCollection {
    private List m_attributes;
    private transient int m_syntheticRefCount;
    private transient int m_bridgeRefCount;
    private transient int m_innerClassesAttributeOffset;
    private static final boolean DISALLOW_MULTIPLE_SYNTHETIC_ATTRIBUTES = false;

    public final Attribute_info get(int offset) {
        return (Attribute_info)this.m_attributes.get(offset);
    }

    public final boolean hasSynthetic() {
        return this.m_syntheticRefCount > 0;
    }

    public final boolean hasBridge() {
        return this.m_bridgeRefCount > 0;
    }

    public final InnerClassesAttribute_info getInnerClassesAttribute() {
        int innerClassesAttributeOffset = this.m_innerClassesAttributeOffset;
        if (innerClassesAttributeOffset < 0) {
            return null;
        }
        return (InnerClassesAttribute_info)this.get(innerClassesAttributeOffset);
    }

    public final int size() {
        return this.m_attributes.size();
    }

    public final long length() {
        long result = 2L;
        int _attributes_count = this.m_attributes.size();
        for (int i = 0; i < _attributes_count; ++i) {
            result += this.get(i).length();
        }
        return result;
    }

    public Object clone() {
        try {
            AttributeCollection _clone = (AttributeCollection)super.clone();
            int attributes_count = this.m_attributes.size();
            _clone.m_attributes = new ArrayList(attributes_count);
            for (int a = 0; a < attributes_count; ++a) {
                _clone.m_attributes.add(((Attribute_info)this.m_attributes.get(a)).clone());
            }
            return _clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public void writeInClassFormat(UDataOutputStream out) throws IOException {
        int attributes_count = this.size();
        out.writeU2(attributes_count);
        for (int i = 0; i < attributes_count; ++i) {
            this.get(i).writeInClassFormat(out);
        }
    }

    public void accept(IClassDefVisitor visitor, Object ctx) {
        visitor.visit(this, ctx);
    }

    public int add(Attribute_info attribute) {
        List attributes = this.m_attributes;
        int result = attributes.size();
        attributes.add(attribute);
        if (attribute instanceof SyntheticAttribute_info) {
            ++this.m_syntheticRefCount;
        } else if (attribute instanceof InnerClassesAttribute_info) {
            if (this.m_innerClassesAttributeOffset >= 0) {
                throw new IllegalArgumentException("this attribute collection already has an InnerClasses attribute");
            }
            this.m_innerClassesAttributeOffset = result;
        } else if (attribute instanceof BridgeAttribute_info) {
            ++this.m_bridgeRefCount;
        }
        return result;
    }

    public Attribute_info set(int offset, Attribute_info attribute) {
        Attribute_info result = this.m_attributes.set(offset, attribute);
        if (result instanceof SyntheticAttribute_info) {
            --this.m_syntheticRefCount;
        } else if (result instanceof InnerClassesAttribute_info) {
            this.m_innerClassesAttributeOffset = -1;
        } else if (result instanceof BridgeAttribute_info) {
            --this.m_bridgeRefCount;
        }
        if (attribute instanceof SyntheticAttribute_info) {
            ++this.m_syntheticRefCount;
        } else if (attribute instanceof InnerClassesAttribute_info) {
            this.m_innerClassesAttributeOffset = offset;
        } else if (attribute instanceof BridgeAttribute_info) {
            ++this.m_bridgeRefCount;
        }
        return result;
    }

    public Attribute_info remove(int offset) {
        Attribute_info result = (Attribute_info)this.m_attributes.remove(offset);
        if (result instanceof SyntheticAttribute_info) {
            --this.m_syntheticRefCount;
        } else if (result instanceof InnerClassesAttribute_info) {
            this.m_innerClassesAttributeOffset = -1;
        } else if (result instanceof BridgeAttribute_info) {
            --this.m_bridgeRefCount;
        }
        return result;
    }

    AttributeCollection(int capacity) {
        this.m_attributes = capacity < 0 ? new ArrayList() : new ArrayList(capacity);
        this.m_innerClassesAttributeOffset = -1;
    }
}

