/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma;

import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.data.mergeCommand;
import com.vladium.emma.instr.instrCommand;
import com.vladium.emma.report.reportCommand;
import com.vladium.emma.runCommand;
import com.vladium.util.IConstants;
import com.vladium.util.Property;
import com.vladium.util.Strings;
import com.vladium.util.XProperties;
import com.vladium.util.args.IOptsParser;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Properties;

public abstract class Command {
    protected final String m_usageToolName;
    protected final String[] m_args;
    protected File m_propertyFile;
    protected Properties m_propertyOverrides;
    protected boolean m_exit;
    protected PrintWriter m_out;
    protected static final String COMMA_DELIMITERS = ", \t\r\n";
    protected static final String PATH_DELIMITERS = ",".concat(File.pathSeparator);
    protected static final String[] USAGE_OPT_NAMES = new String[]{"h", "help"};
    protected static final int STDOUT_WIDTH = 80;
    protected static final int RC_OK = 0;
    protected static final int RC_USAGE = 1;
    protected static final int RC_UNEXPECTED = 2;

    /*
     * WARNING - void declaration
     */
    public static Command create(String name, String usageName, String[] args) {
        void var3_3;
        Command tool;
        if ("run".equals(name)) {
            tool = new runCommand(usageName, args);
        } else if ("instr".equals(name)) {
            tool = new instrCommand(usageName, args);
        } else if ("report".equals(name)) {
            tool = new reportCommand(usageName, args);
        } else if ("merge".equals(name)) {
            tool = new mergeCommand(usageName, args);
        } else {
            throw new IllegalArgumentException("unknown command: [" + name + "]");
        }
        var3_3.initialize();
        return var3_3;
    }

    public abstract void run();

    protected Command(String usageToolName, String[] args) {
        this.m_usageToolName = usageToolName;
        this.m_args = args != null ? (String[])args.clone() : IConstants.EMPTY_STRING_ARRAY;
    }

    protected abstract String usageArgsMsg();

    protected void initialize() {
        this.m_exit = false;
        if (this.m_out != null) {
            try {
                this.m_out.flush();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.m_out = new PrintWriter(System.out, true);
    }

    protected final String getToolName() {
        String clsName = this.getClass().getName();
        return clsName.substring(0, clsName.length() - 7);
    }

    protected final IOptsParser getOptParser(ClassLoader loader) {
        return IOptsParser.Factory.create(Command.usageResName(this.getToolName()), loader, Command.usageMsgPrefix(this.m_usageToolName), USAGE_OPT_NAMES);
    }

    protected final boolean processOpt(IOptsParser.IOpt opt) {
        String on = opt.getCanonicalName();
        if ("exit".equals(on)) {
            this.m_exit = Command.getOptionalBooleanOptValue(opt);
            return true;
        }
        if ("p".equals(on)) {
            this.m_propertyFile = new File(opt.getFirstValue());
            return true;
        }
        if ("verbose".equals(on)) {
            this.setPropertyOverride("verbosity.level", "verbose");
            return true;
        }
        if ("quiet".equals(on)) {
            this.setPropertyOverride("verbosity.level", "warning");
            return true;
        }
        if ("silent".equals(on)) {
            this.setPropertyOverride("verbosity.level", "severe");
            return true;
        }
        if ("debug".equals(on)) {
            if (opt.getValueCount() == 0) {
                this.setPropertyOverride("verbosity.level", "trace1");
            } else {
                this.setPropertyOverride("verbosity.level", opt.getFirstValue());
            }
            return true;
        }
        if ("debugcls".equals(on)) {
            this.setPropertyOverride("verbosity.filter", Strings.toListForm(Strings.merge(opt.getValues(), COMMA_DELIMITERS, true), ','));
            return true;
        }
        return false;
    }

    protected final void processCmdPropertyOverrides(IOptsParser.IOpts parsedopts) {
        IOptsParser.IOpt[] popts = parsedopts.getOpts("D");
        if (popts != null && popts.length != 0) {
            XProperties cmdOverrides = new XProperties();
            for (int o = 0; o < popts.length; ++o) {
                IOptsParser.IOpt opt = popts[o];
                String on = opt.getName().substring(opt.getPatternPrefix().length());
                cmdOverrides.setProperty(on, opt.getFirstValue());
            }
            this.m_propertyOverrides = Property.combine(cmdOverrides, this.m_propertyOverrides);
        }
    }

    protected final boolean processFilePropertyOverrides() {
        if (this.m_propertyFile != null) {
            Properties fileOverrides;
            try {
                fileOverrides = Property.getPropertiesFromFile(this.m_propertyFile);
            }
            catch (IOException ioe) {
                this.exit(true, "property override file [" + this.m_propertyFile.getAbsolutePath() + "] could not be read", ioe, 1);
                return false;
            }
            this.m_propertyOverrides = Property.combine(this.m_propertyOverrides, fileOverrides);
        }
        return true;
    }

    protected final void usageexit(IOptsParser parser, int level, String msg) {
        if (msg != null) {
            this.m_out.print(Command.usageMsgPrefix(this.m_usageToolName));
            this.m_out.println(msg);
        }
        if (parser != null) {
            this.m_out.println();
            this.m_out.print(Command.usageMsgPrefix(this.m_usageToolName));
            this.m_out.println(Command.toolNameToCommandName(this.m_usageToolName) + " " + this.usageArgsMsg() + ",");
            this.m_out.println("  where options include:");
            this.m_out.println();
            parser.usage(this.m_out, level, 80);
        }
        this.m_out.println();
        this.exit(true, null, null, 1);
    }

    protected final void exit(boolean showBuildID, String msg, Throwable t, int rc) throws EMMARuntimeException {
        if (showBuildID) {
            this.m_out.println("[EMMA v2.0, build 5312]");
        }
        if (msg != null) {
            this.m_out.print(Command.toolNameToCommandName(this.m_usageToolName) + ": ");
            this.m_out.println(msg);
        }
        if (rc != 0) {
            if (this.m_exit) {
                if (t != null) {
                    t.printStackTrace(this.m_out);
                }
                System.exit(rc);
            } else {
                if (t instanceof EMMARuntimeException) {
                    throw (EMMARuntimeException)t;
                }
                if (t != null) {
                    throw msg != null ? new EMMARuntimeException(msg, t) : new EMMARuntimeException("unexpected failure: ", t);
                }
            }
        } else if (this.m_exit) {
            System.exit(0);
        }
    }

    protected static boolean getOptionalBooleanOptValue(IOptsParser.IOpt opt) {
        if (opt.getValueCount() == 0) {
            return true;
        }
        String v = opt.getFirstValue().toLowerCase();
        return Property.toBoolean(v);
    }

    protected static String[] getListOptValue(IOptsParser.IOpt opt, String delimiters, boolean processAtFiles) throws IOException {
        return Strings.mergeAT(opt.getValues(), delimiters, processAtFiles);
    }

    protected static String usageMsgPrefix(String toolName) {
        return Command.toolNameToCommandName(toolName).concat(" usage: ");
    }

    protected static String usageResName(String toolName) {
        return toolName.replace('.', '/').concat("_usage.res");
    }

    protected static String toolNameToCommandName(String toolName) {
        int lastDot = toolName.lastIndexOf(46);
        return lastDot > 0 ? toolName.substring(lastDot + 1) : toolName;
    }

    private void setPropertyOverride(String key, String value) {
        Properties propertyOverrides = this.m_propertyOverrides;
        if (propertyOverrides == null) {
            this.m_propertyOverrides = propertyOverrides = new XProperties();
        }
        propertyOverrides.setProperty(key, value);
    }
}

