/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore;

import com.google.appengine.api.blobstore.BlobKey;
import java.io.Serializable;
import java.util.Date;

public class BlobInfo
implements Serializable {
    protected final BlobKey blobKey;
    protected final String contentType;
    protected final Date creation;
    protected final String filename;
    protected final long size;

    public BlobInfo(BlobKey blobKey, String contentType, Date creation, String filename, long size) {
        if (blobKey == null) {
            throw new NullPointerException("blobKey must not be null");
        }
        if (contentType == null) {
            throw new NullPointerException("contentType must not be null");
        }
        if (creation == null) {
            throw new NullPointerException("creation must not be null");
        }
        if (filename == null) {
            throw new NullPointerException("filename must not be null");
        }
        this.blobKey = blobKey;
        this.contentType = contentType;
        this.creation = creation;
        this.filename = filename;
        this.size = size;
    }

    public BlobKey getBlobKey() {
        return this.blobKey;
    }

    public String getContentType() {
        return this.contentType;
    }

    public Date getCreation() {
        return this.creation;
    }

    public String getFilename() {
        return this.filename;
    }

    public long getSize() {
        return this.size;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlobInfo) {
            BlobInfo bi = (BlobInfo)obj;
            return this.blobKey.equals(bi.blobKey) && this.contentType.equals(bi.contentType) && this.creation.equals(bi.creation) && this.filename.equals(bi.filename) && this.size == bi.size;
        }
        return false;
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 37 + this.blobKey.hashCode();
        hash = hash * 37 + this.contentType.hashCode();
        hash = hash * 37 + this.filename.hashCode();
        return hash;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("<BlobInfo: ");
        builder.append(this.blobKey);
        builder.append(", contentType = ");
        builder.append(this.contentType);
        builder.append(", creation = ");
        builder.append(this.creation.toString());
        builder.append(", filename = ");
        builder.append(this.filename);
        builder.append(", size = ");
        builder.append(Long.toString(this.size));
        builder.append(">");
        return builder.toString();
    }
}

