/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.appengine.query;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.Entity;
import java.util.Iterator;
import java.util.ListIterator;
import javax.jdo.JDOUserException;
import org.datanucleus.exceptions.NucleusUserException;
import org.datanucleus.store.appengine.Utils;
import org.datanucleus.store.appengine.query.LazyResult;
import org.datanucleus.store.query.AbstractQueryResult;
import org.datanucleus.store.query.Query;
import org.datanucleus.util.NucleusLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class StreamingQueryResult
extends AbstractQueryResult {
    private final LazyResult<Object> lazyResult;
    private boolean loadResultsAtCommit = true;
    private final Cursor endCursor;

    public StreamingQueryResult(Query query, Iterable<Entity> lazyEntities, Utils.Function<Entity, Object> entityToPojoFunc, Cursor endCursor) {
        super(query);
        this.lazyResult = new LazyResult<Object>(lazyEntities, entityToPojoFunc);
        this.endCursor = endCursor;
        String ext = (String)query.getExtension("datanucleus.query.loadResultsAtCommit");
        if (ext != null) {
            this.loadResultsAtCommit = Boolean.valueOf(ext);
        }
    }

    protected void closingConnection() {
        if (this.loadResultsAtCommit && this.isOpen()) {
            try {
                this.lazyResult.resolveAll();
            }
            catch (NucleusUserException jpue) {
                NucleusLogger.QUERY.warn((Object)("Exception thrown while loading remaining rows of query : " + jpue.getMessage()));
            }
            catch (JDOUserException ue) {
                NucleusLogger.QUERY.warn((Object)("Exception thrown while loading remaining rows of query : " + ue.getMessage()));
            }
        }
    }

    protected void closeResults() {
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public Object get(int index) {
        return this.lazyResult.get(index);
    }

    void resolveNext() {
        this.lazyResult.resolveNext();
    }

    public Iterator<Object> iterator() {
        return this.lazyResult.listIterator();
    }

    public ListIterator<Object> listIterator() {
        return this.lazyResult.listIterator();
    }

    public int size() {
        return this.lazyResult.size();
    }

    Cursor getEndCursor() {
        return this.endCursor;
    }
}

