/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.base;

import com.google.appengine.repackaged.com.google.common.base.Throwables;
import com.google.common.annotations.GoogleInternal;

@GoogleInternal
public class GoogleException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String internalMessage;
    private String externalMessage = "A system error has occurred";

    public GoogleException() {
    }

    public GoogleException(Throwable t) {
        super(t);
        this.setInternalMessage(Throwables.getStackTraceAsString(t));
    }

    public GoogleException(Throwable t, String externalMessage) {
        super(externalMessage, t);
        this.setInternalMessage(Throwables.getStackTraceAsString(t));
        this.setExternalMessage(externalMessage);
    }

    public GoogleException(String internalMessage) {
        super(internalMessage);
        this.setInternalMessage(internalMessage);
    }

    public GoogleException(String internalMessage, String externalMessage) {
        super(internalMessage);
        this.setInternalMessage(internalMessage);
        this.setExternalMessage(externalMessage);
    }

    public int getErrorCode() {
        return -999;
    }

    public String getInternalMessage() {
        return this.internalMessage;
    }

    public void setInternalMessage(String s) {
        this.internalMessage = s;
    }

    public String getExternalMessage() {
        return this.externalMessage;
    }

    public void setExternalMessage(String s) {
        this.externalMessage = s;
    }

    public String getMessage() {
        return this.getInternalMessage();
    }
}

