// CORBA client here
#ifndef __DATACONNECTORLIB_H__
#define __DATACONNECTORLIB_H__

#include "DatabaseC.h"
#include "DatabaseNotification/DatabaseNotificationTypeSupportImpl.h"

using namespace System;
using namespace System::Threading;

class DataServerConnectorState {
	CORBA::ORB_var orb_;  // need to keep the orb alive
	Database_var database_;  // the servant, too
public:
	DataServerConnectorState(CORBA::ORB_ptr orb, Database_ptr database);
	Database_ptr DatabasePtr() { return database_; }
	CORBA::ORB_ptr OrbPtr() { return orb_; }
};


// wrap the CORBA enum in a .NET enum
public enum class Notification {
	CREATED = NOTIFICATION_CREATED,
	READ = NOTIFICATION_READ,
	UPDATED = NOTIFICATION_UPDATED,
	DELETED = NOTIFICATION_DELETED
};


public ref class ProcessNotificationEventArgs : public EventArgs {
	Int64 id_;
	String^ tableName_;
	Notification notificationType_;
public:
	ProcessNotificationEventArgs(Int64 id, String^ tableName, Notification notificationType) :
	  id_(id), tableName_(tableName), notificationType_(notificationType) {}
	property Int64 ID { Int64 get() { return id_; } }
	property String^ TableName { String^ get() { return tableName_; } }
	property Notification NotificationType { Notification get() { return notificationType_; } }
};



// wrap CORBA interaction with a .NET class
public ref class DataServerConnector {
	DataServerConnectorState *state_;  // can't put an unmanaged thing in a ref class, but a pointer to an unmanaged thing is okay
	Thread^ thread_;
	AutoResetEvent startupEvent_;
	void Run();
	static void ThreadStart(Object^ param);
public:
	DataServerConnector();
	~DataServerConnector();
	void Start();
	void Shutdown();
	bool CreateItem(String ^description, Int64 %id);
	bool ReadItem(Int64 id, String^% description);
	bool UpdateItem(Int64 id, String^ description);
	bool DeleteItem(Int64 id);

	delegate void ProcessNotificationEventHandler(Object^ sender, ProcessNotificationEventArgs ^args);
	ProcessNotificationEventHandler^ pProcessNotification_;
	event ProcessNotificationEventHandler^ ProcessNotification
	{
		void add(ProcessNotificationEventHandler^ p) { pProcessNotification_ +=p; }
		void remove(ProcessNotificationEventHandler^ p) { pProcessNotification_ -=p; }
		void raise(Object^ obj, ProcessNotificationEventArgs^ args) {
			if (pProcessNotification_!=nullptr)
				pProcessNotification_(obj, args);
		}
	}
};


public ref class DataConnectorException : public Exception {
public:
	DataConnectorException(String ^msg) : Exception(msg) {}
};

#endif
