package com.ociweb.jnb.april2008;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import static com.ociweb.jnb.april2008.CreateGenericCollectionsConveniently.Party.Donkey;
import static com.ociweb.jnb.april2008.CreateGenericCollectionsConveniently.Party.Elephant;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
public class CreateGenericCollectionsConveniently {
    public enum Party {
        Elephant, Donkey
    }
    public static void main(String[] args) {
        Map<Party, String> partyNames = Maps.immutableMap(Donkey, "Democrat", Elephant, "Republican");
        Map<String, Party> affiliations = Maps.immutableMap("Barack", Donkey, "Hillary", Donkey, "John", Elephant);
        Set<String> candidates = Sets.immutableSortedSet("John", "Barack", "Hillary");
        for (String candidate : candidates) {
            System.out.printf("%s is a %s\n", candidate, partyNames.get(affiliations.get(candidate)));
        }
        // Before
        {
            List<String> l1 = Lists.newArrayList("Monday", "Tuesday", "Wednesday");
            List<Double> l2 = Lists.newLinkedList(1.0, 2.0, 3.0);
            Set<String> s1 = Sets.newHashSet("Keys", "Badge", "Wallet");
            Map<String, String> m1 = Maps.newHashMap();
        }
        // After
        {
            List<String> l1 = Arrays.asList("Monday", "Tuesday", "Wednesday");
            List<Double> l2 = Arrays.asList(1.0, 2.0, 3.0);
            Set<String> s1 = new HashSet<String>();
            Collections.addAll(s1, "Keys", "Badge", "Wallet");
            Map<String, String> m1 = new HashMap<String, String>();
        }
    }
}
