package com.ociweb.jnb.april2008;
import com.google.common.collect.BiMap;
import com.google.common.collect.Maps;
public class DoInverseLookupsWithBiMap {
    public static void main(String[] args) {
        BiMap<String, String> denomToPortrait = Maps.newHashBiMap();
        denomToPortrait.put("One", "Washington");
        denomToPortrait.put("Five", "Lincoln");
        denomToPortrait.put("Ten", "Hamilton");
        denomToPortrait.put("Twenty", "Jackson");
        denomToPortrait.put("Fifty", "Grant");
        denomToPortrait.put("Hundred", "Franklin");
        // Do some "forward" lookups...
        System.out.printf("%s is on the %s\n", denomToPortrait.get("Ten"), "Ten");
        System.out.printf("%s is on the %s\n", denomToPortrait.get("Fifty"), "Fifty");
        // Do some "reverse" lookups...
        BiMap<String, String> portraitToDenom = denomToPortrait.inverse();
        System.out.printf("%s is on the %s\n", "Jackson", portraitToDenom.get("Jackson"));
        System.out.printf("%s is on the %s\n", "Lincoln", portraitToDenom.get("Lincoln"));
    }
}
