/*
 * Copyright (c) 2011, Object Computing, Inc.
 * All Rights reserved
 * See the file license.txt for licensing information.
 */
package com.ociweb.tnb;

import android.app.ListActivity;
import android.content.Intent;
import android.hardware.Sensor;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListView;

import java.util.ArrayList;
import java.util.List;

/**
 * ListSensors is and Android Activity that displays a list of the
 * sensors known to the SensorManager.  When an item is selected
 * from the list, the SensorDisplay activity is started to display
 * information about that sensor.
 */
public class ListSensors extends ListActivity
{
    private ArrayList<String> mSensorNames;

    @Override
    public void onCreate(Bundle savedInstanceState)
    {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.list_sensors);
        // Get an instance of the SensorManager
        SensorManager mSensorManager = (SensorManager) getSystemService(SENSOR_SERVICE);
        mSensorManager.getDefaultSensor(Sensor.TYPE_ACCELEROMETER);
        List<Sensor> mSensorList = mSensorManager.getSensorList(Sensor.TYPE_ALL);
        mSensorNames = new ArrayList<String>(mSensorList.size());
        for (Sensor sensor : mSensorList) {
            mSensorNames.add(sensor.getName());
        }
        ArrayAdapter<String> mSensorArrayAdapter = new ArrayAdapter<String>(
                this, android.R.layout.simple_list_item_1, mSensorNames);

        setListAdapter(mSensorArrayAdapter);
    }
    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
        super.onListItemClick(l, v, position, id);
        Intent i = new Intent(this,SensorDisplay.class);
        i.putExtra(SensorDisplay.SENSOR_NAME, mSensorNames.get((int)id));
        this.startActivity(i);
    }
}
