package com.ociweb.tnb;

import android.app.Activity;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Bundle;
import android.widget.TextView;
import android.widget.Toast;

import java.util.List;

/*
 * Copyright (c) 2011, Object Computing, Inc.
 * All Rights reserved
 * See the file license.txt for licensing information.
 */
public class VectorDisplay extends Activity {
    public static final String SENSOR_NAME = "SENSOR_NAME";
    private String mSensorName = "";

    private TextView mCaption;
    private VectorView mView;
    private SensorManager mSensorManager;
    private Sensor mSensor;
    private SensorEventListener mSensorListener;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.display_vector);
        mCaption = (TextView) findViewById(R.id.vector_caption);
        mView = (VectorView) findViewById(R.id.vector_view);
        mSensorName = getIntent().getExtras().getString(SENSOR_NAME);
        mSensorManager = (SensorManager) getSystemService(SENSOR_SERVICE);
        List<Sensor> sensorList = mSensorManager.getSensorList(Sensor.TYPE_ALL);
        for (Sensor sensor : sensorList) {
            if (sensor.getName().equals(mSensorName)) {
                mSensor = sensor;
                break;
            }
        }
        if(mSensor == null)
        {
            Toast.makeText(this, R.string.unknown_sensor, Toast.LENGTH_LONG).show();
        }
        else
        {
/* (seems like a good idea, but some devices return a huge value relative to actual readings
            float mRange = mSensor.getMaximumRange();
            if(mRange > 0.0f)
            {
                mView.setScale(mRange, mRange, mRange);
            }
*/
            mSensorListener = new SensorEventListener(){
                public void onSensorChanged(SensorEvent sensorEvent) {
                    mCaption.setText(mSensorName + ": ("
                            + sensorEvent.values[0] + ","
                            + sensorEvent.values[1] + ','
                            + sensorEvent.values[2] + ")"
                    );
                    mView.setVector(sensorEvent.values[0], sensorEvent.values[1], sensorEvent.values[2]);
                }

                public void onAccuracyChanged(Sensor sensor, int i) {
                    // Ignore this
                }
            };
            mSensorManager.registerListener(mSensorListener, mSensor, SensorManager.SENSOR_DELAY_UI);
        }

    }
}