/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.jruby.IRuby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRange;
import org.jruby.RubyString;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.util.ConversionIterator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.ArrayMetaClass;
import org.jruby.runtime.builtin.meta.StringMetaClass;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.Pack;
import org.jruby.util.collections.IdentitySet;

public class RubyArray
extends RubyObject
implements List {
    private List list;
    private boolean tmpLock;

    private RubyArray(IRuby runtime, List list) {
        super(runtime, runtime.getClass("Array"));
        this.list = list;
    }

    public List getList() {
        return this.list;
    }

    public IRubyObject[] toJavaArray() {
        return this.list.toArray(new IRubyObject[this.getLength()]);
    }

    @Override
    public RubyArray convertToArray() {
        return this;
    }

    public boolean isTmpLock() {
        return this.tmpLock;
    }

    public void setTmpLock(boolean tmpLock) {
        this.tmpLock = tmpLock;
    }

    public int getLength() {
        return this.list.size();
    }

    public boolean includes(IRubyObject item) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        int n = this.getLength();
        for (int i = 0; i < n; ++i) {
            if (!item.callMethod(context, "==", this.entry(i)).isTrue()) continue;
            return true;
        }
        return false;
    }

    @Override
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(((Object)this.list).hashCode());
    }

    public void modify() {
        this.testFrozen("Array");
        if (this.isTmpLock()) {
            throw this.getRuntime().newTypeError("can't modify array during sort");
        }
        if (this.isTaint() && this.getRuntime().getSafeLevel() >= 4) {
            throw this.getRuntime().newSecurityError("Insecure: can't modify array");
        }
    }

    private void autoExpand(long toLength) {
        int i = this.getLength();
        while ((long)i < toLength) {
            this.list.add(this.getRuntime().getNil());
            ++i;
        }
    }

    private IRubyObject store(long index, IRubyObject value) {
        this.modify();
        if (index < 0L && (index += (long)this.getLength()) < 0L) {
            throw this.getRuntime().newIndexError("index " + (index - (long)this.getLength()) + " out of array");
        }
        this.autoExpand(index + 1L);
        this.list.set((int)index, value);
        return value;
    }

    public IRubyObject entry(long offset) {
        return this.entry(offset, false);
    }

    public IRubyObject entry(long offset, boolean throwException) {
        if (this.getLength() == 0) {
            if (throwException) {
                throw this.getRuntime().newIndexError("index " + offset + " out of array");
            }
            return this.getRuntime().getNil();
        }
        if (offset < 0L) {
            offset += (long)this.getLength();
        }
        if (offset < 0L || (long)this.getLength() <= offset) {
            if (throwException) {
                throw this.getRuntime().newIndexError("index " + offset + " out of array");
            }
            return this.getRuntime().getNil();
        }
        return (IRubyObject)this.list.get((int)offset);
    }

    public IRubyObject fetch(IRubyObject[] args) {
        this.checkArgumentCount(args, 1, 2);
        RubyInteger index = args[0].convertToInteger();
        try {
            return this.entry(index.getLongValue(), true);
        }
        catch (RaiseException e) {
            ThreadContext tc = this.getRuntime().getCurrentContext();
            RubyException raisedException = e.getException();
            if (raisedException.isKindOf(this.getRuntime().getClassFromPath("IndexError"))) {
                if (args.length > 1) {
                    return args[1];
                }
                if (tc.isBlockGiven()) {
                    return tc.yield(index);
                }
            }
            throw e;
        }
    }

    public IRubyObject insert(IRubyObject[] args) {
        this.checkArgumentCount(args, 1, -1);
        if (args.length == 1) {
            return this;
        }
        long offset = args[0].convertToInteger().getLongValue();
        if (offset < 0L && (long)this.getLength() + offset < 0L) {
            throw this.getRuntime().newIndexError("index " + ((long)this.getLength() + offset) + " out of array");
        }
        if (offset > (long)this.getLength()) {
            long difference = offset - (long)this.getLength();
            IRubyObject nil = this.getRuntime().getNil();
            for (long i = 0L; i < difference; ++i) {
                this.list.add(nil);
            }
        }
        if (offset < 0L) {
            offset += (long)(this.getLength() + 1);
        }
        for (int i = 1; i < args.length; ++i) {
            this.list.add((int)(offset + (long)i - 1L), args[i]);
        }
        return this;
    }

    public RubyArray transpose() {
        RubyArray newArray = this.getRuntime().newArray();
        int length = this.getLength();
        if (length == 0) {
            return newArray;
        }
        for (int i = 0; i < length; ++i) {
            if (this.entry(i) instanceof RubyArray) continue;
            throw this.getRuntime().newTypeError("Some error");
        }
        int width = ((RubyArray)this.entry(0L)).getLength();
        for (int j = 0; j < width; ++j) {
            RubyArray columnArray = this.getRuntime().newArray(length);
            for (int i = 0; i < length; ++i) {
                try {
                    columnArray.append((IRubyObject)((RubyArray)this.entry((long)((long)i))).list.get(j));
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    throw this.getRuntime().newIndexError("element size differ (" + i + " should be " + width + ")");
                }
            }
            newArray.append(columnArray);
        }
        return newArray;
    }

    public IRubyObject values_at(IRubyObject[] args) {
        RubyArray newArray = this.getRuntime().newArray();
        for (int i = 0; i < args.length; ++i) {
            IRubyObject o = this.aref(new IRubyObject[]{args[i]});
            if (args[i] instanceof RubyRange) {
                if (!(o instanceof RubyArray)) continue;
                Iterator j = ((RubyArray)o).getList().iterator();
                while (j.hasNext()) {
                    newArray.append((IRubyObject)j.next());
                }
                continue;
            }
            newArray.append(o);
        }
        return newArray;
    }

    public RubyArray unshift(IRubyObject item) {
        this.modify();
        this.list.add(0, item);
        return this;
    }

    public IRubyObject subseq(long beg, long len) {
        int length = this.getLength();
        if (beg > (long)length || beg < 0L || len < 0L) {
            return this.getRuntime().getNil();
        }
        if (beg + len > (long)length) {
            len = (long)length - beg;
        }
        return len <= 0L ? this.getRuntime().newArray(0) : this.getRuntime().newArray(new ArrayList(this.list.subList((int)beg, (int)(len + beg))));
    }

    public void replace(long beg, long len, IRubyObject repl) {
        int length = this.getLength();
        if (len < 0L) {
            throw this.getRuntime().newIndexError("Negative array length: " + len);
        }
        if (beg < 0L) {
            beg += (long)length;
        }
        if (beg < 0L) {
            throw this.getRuntime().newIndexError("Index out of bounds: " + beg);
        }
        this.modify();
        int i = 0;
        while (beg < (long)this.getLength() && (long)i < len) {
            this.list.remove((int)beg);
            ++i;
        }
        this.autoExpand(beg);
        if (repl instanceof RubyArray) {
            List repList = ((RubyArray)repl).getList();
            this.list.addAll((int)beg, new ArrayList(repList));
        } else if (!repl.isNil()) {
            this.list.add((int)beg, repl);
        }
    }

    private boolean flatten(List array) {
        return this.flatten(array, new IdentitySet(), null, -1);
    }

    private boolean flatten(List array, IdentitySet visited, List toModify, int index) {
        if (visited.contains(array)) {
            throw this.getRuntime().newArgumentError("tried to flatten recursive array");
        }
        visited.add(array);
        boolean isModified = false;
        for (int i = array.size() - 1; i >= 0; --i) {
            Object elem = array.get(i);
            if (elem instanceof RubyArray) {
                if (toModify == null) {
                    array.remove(i);
                    this.flatten(((RubyArray)elem).getList(), visited, array, i);
                } else {
                    this.flatten(((RubyArray)elem).getList(), visited, toModify, index);
                }
                isModified = true;
                continue;
            }
            if (toModify == null) continue;
            toModify.add(index, elem);
        }
        visited.remove(array);
        return isModified;
    }

    public static final RubyArray newArray(IRuby runtime, long len) {
        return new RubyArray(runtime, new ArrayList((int)len));
    }

    public static final RubyArray newArray(IRuby runtime) {
        return new RubyArray(runtime, new ArrayList(16));
    }

    public static RubyArray newArray(IRuby runtime, IRubyObject obj) {
        ArrayList<IRubyObject> list = new ArrayList<IRubyObject>(1);
        list.add(obj);
        return new RubyArray(runtime, list);
    }

    public static RubyArray newArray(IRuby runtime, IRubyObject car, IRubyObject cdr) {
        ArrayList<IRubyObject> list = new ArrayList<IRubyObject>(2);
        list.add(car);
        list.add(cdr);
        return new RubyArray(runtime, list);
    }

    public static final RubyArray newArray(IRuby runtime, List list) {
        return new RubyArray(runtime, list);
    }

    public static RubyArray newArray(IRuby runtime, IRubyObject[] args) {
        ArrayList<IRubyObject> list = new ArrayList<IRubyObject>(args.length);
        for (int i = 0; i < args.length; ++i) {
            list.add(args[i]);
        }
        return new RubyArray(runtime, list);
    }

    public RubyFixnum length() {
        return this.getRuntime().newFixnum(this.getLength());
    }

    public RubyArray push(IRubyObject[] items) {
        this.modify();
        boolean tainted = false;
        for (int i = 0; i < items.length; ++i) {
            tainted |= items[i].isTaint();
            this.list.add(items[i]);
        }
        this.setTaint(this.isTaint() || tainted);
        return this;
    }

    public RubyArray append(IRubyObject value) {
        this.modify();
        this.list.add(value);
        this.infectBy(value);
        return this;
    }

    public IRubyObject pop() {
        this.modify();
        int length = this.getLength();
        return length == 0 ? this.getRuntime().getNil() : (IRubyObject)this.list.remove(length - 1);
    }

    public IRubyObject shift() {
        this.modify();
        return this.getLength() == 0 ? this.getRuntime().getNil() : (IRubyObject)this.list.remove(0);
    }

    public RubyArray unshift(IRubyObject[] items) {
        this.modify();
        boolean taint = false;
        for (int i = 0; i < items.length; ++i) {
            taint |= items[i].isTaint();
            this.list.add(i, items[i]);
        }
        this.setTaint(this.isTaint() || taint);
        return this;
    }

    public RubyBoolean include_p(IRubyObject item) {
        return this.getRuntime().newBoolean(this.includes(item));
    }

    @Override
    public RubyBoolean frozen() {
        return this.getRuntime().newBoolean(this.isFrozen() || this.isTmpLock());
    }

    @Override
    public IRubyObject initialize(IRubyObject[] args) {
        int argc = this.checkArgumentCount(args, 0, 2);
        RubyArray arrayInitializer = null;
        long len = 0L;
        if (argc > 0) {
            if (args[0] instanceof RubyArray) {
                arrayInitializer = (RubyArray)args[0];
            } else {
                len = this.convertToLong(args[0]);
            }
        }
        this.modify();
        if (arrayInitializer != null) {
            this.list = new ArrayList(arrayInitializer.list);
            return this;
        }
        if (len < 0L) {
            throw this.getRuntime().newArgumentError("negative array size");
        }
        if (len > Integer.MAX_VALUE) {
            throw this.getRuntime().newArgumentError("array size too big");
        }
        this.list = new ArrayList((int)len);
        ThreadContext tc = this.getRuntime().getCurrentContext();
        if (len > 0L) {
            if (tc.isBlockGiven()) {
                int i = 0;
                while ((long)i < len) {
                    this.list.add(tc.yield(new RubyFixnum(this.getRuntime(), i)));
                    ++i;
                }
            } else {
                IRubyObject obj = argc == 2 ? args[1] : this.getRuntime().getNil();
                this.list.addAll(Collections.nCopies((int)len, obj));
            }
        }
        return this;
    }

    public IRubyObject aref(IRubyObject[] args) {
        int argc = this.checkArgumentCount(args, 1, 2);
        if (argc == 2) {
            long beg = RubyNumeric.fix2long(args[0]);
            long len = RubyNumeric.fix2long(args[1]);
            if (beg < 0L) {
                beg += (long)this.getLength();
            }
            return this.subseq(beg, len);
        }
        if (args[0] instanceof RubyFixnum) {
            return this.entry(RubyNumeric.fix2long(args[0]));
        }
        if (args[0] instanceof RubyBignum) {
            throw this.getRuntime().newIndexError("index too big");
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getLength(), true, false);
            return begLen == null ? RubyArray.newArray(this.getRuntime()) : this.subseq(begLen[0], begLen[1]);
        }
        return this.entry(args[0].convertToInteger().getLongValue());
    }

    public IRubyObject aset(IRubyObject[] args) {
        int argc = this.checkArgumentCount(args, 2, 3);
        if (argc == 3) {
            long beg = args[0].convertToInteger().getLongValue();
            long len = args[1].convertToInteger().getLongValue();
            this.replace(beg, len, args[2]);
            return args[2];
        }
        if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getLength(), false, true);
            this.replace(begLen[0], begLen[1], args[1]);
            return args[1];
        }
        if (args[0] instanceof RubyBignum) {
            throw this.getRuntime().newIndexError("Index too large");
        }
        return this.store(args[0].convertToInteger().getLongValue(), args[1]);
    }

    public IRubyObject at(IRubyObject pos) {
        return this.entry(this.convertToLong(pos));
    }

    private long convertToLong(IRubyObject pos) {
        if (pos instanceof RubyNumeric) {
            return ((RubyNumeric)pos).getLongValue();
        }
        throw this.getRuntime().newTypeError("cannot convert " + pos.getType().getBaseName() + " to Integer");
    }

    public RubyArray concat(IRubyObject obj) {
        this.modify();
        RubyArray other = obj.convertToArray();
        this.list.addAll(other.getList());
        this.infectBy(other);
        return this;
    }

    @Override
    public IRubyObject inspect() {
        int length = this.getLength();
        if (length == 0) {
            return this.getRuntime().newString("[]");
        }
        RubyString result = this.getRuntime().newString("[");
        RubyString separator = this.getRuntime().newString(", ");
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                result.append(separator);
            }
            result.append(this.entry(i).callMethod(context, "inspect"));
        }
        result.cat("]");
        return result;
    }

    public IRubyObject first(IRubyObject[] args) {
        this.checkArgumentCount(args, 0, 1);
        if (args.length == 0) {
            return this.getLength() == 0 ? this.getRuntime().getNil() : this.entry(0L);
        }
        if (!(args[0] instanceof RubyInteger)) {
            throw this.getRuntime().newTypeError("Cannot convert " + args[0].getType() + " into Integer");
        }
        long length = ((RubyInteger)args[0]).getLongValue();
        if (length < 0L) {
            throw this.getRuntime().newArgumentError("negative array size (or size too big)");
        }
        return this.subseq(0L, length);
    }

    public IRubyObject last(IRubyObject[] args) {
        int count = this.checkArgumentCount(args, 0, 1);
        int length = this.getLength();
        int listSize = this.list.size();
        int sublistSize = 0;
        int startIndex = 0;
        switch (count) {
            case 0: {
                return length == 0 ? this.getRuntime().getNil() : this.entry(length - 1);
            }
            case 1: {
                sublistSize = RubyNumeric.fix2int(args[0]);
                if (sublistSize == 0) {
                    return this.getRuntime().newArray();
                }
                if (sublistSize < 0) {
                    throw this.getRuntime().newArgumentError("negative array size (or size too big)");
                }
                startIndex = sublistSize > listSize ? 0 : listSize - sublistSize;
                return this.getRuntime().newArray(this.list.subList(startIndex, listSize));
            }
        }
        assert (false);
        return null;
    }

    public IRubyObject each() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        int len = this.getLength();
        for (int i = 0; i < len; ++i) {
            context.yield(this.entry(i));
        }
        return this;
    }

    public IRubyObject each_index() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        int len = this.getLength();
        for (int i = 0; i < len; ++i) {
            context.yield(this.getRuntime().newFixnum(i));
        }
        return this;
    }

    public IRubyObject reverse_each() {
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (long i = (long)this.getLength(); i > 0L; --i) {
            context.yield(this.entry(i - 1L));
        }
        return this;
    }

    public RubyString join(RubyString sep) {
        StringBuffer buf = new StringBuffer();
        int length = this.getLength();
        if (length == 0) {
            this.getRuntime().newString("");
        }
        boolean taint = this.isTaint() || sep.isTaint();
        IRubyObject tmp = null;
        for (long i = 0L; i < (long)length; ++i) {
            tmp = this.entry(i);
            taint |= tmp.isTaint();
            if (!(tmp instanceof RubyString)) {
                tmp = tmp instanceof RubyArray ? ((RubyArray)tmp).join(sep) : RubyString.objAsString(tmp);
            }
            if (i > 0L && !sep.isNil()) {
                buf.append(sep.toString());
            }
            buf.append(((RubyString)tmp).toString());
        }
        RubyString str = RubyString.newString(this.getRuntime(), buf.toString());
        str.setTaint(taint);
        return str;
    }

    public RubyString join(IRubyObject[] args) {
        int argc = this.checkArgumentCount(args, 0, 1);
        IRubyObject sep = argc == 1 ? args[0] : this.getRuntime().getGlobalVariables().get("$,");
        return this.join(sep.isNil() ? this.getRuntime().newString("") : RubyString.stringValue(sep));
    }

    @Override
    public IRubyObject to_s() {
        IRubyObject separatorObject = this.getRuntime().getGlobalVariables().get("$,");
        RubyString separator = separatorObject.isNil() ? this.getRuntime().newString("") : RubyString.stringValue(separatorObject);
        return this.join(separator);
    }

    public RubyArray to_a() {
        return this;
    }

    public IRubyObject to_ary() {
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRubyObject array_op_equal(IRubyObject obj) {
        RubyArray ary;
        if (this == obj) {
            return this.getRuntime().getTrue();
        }
        if (!(obj instanceof RubyArray)) {
            if (!obj.respondsTo("to_ary")) return this.getRuntime().getFalse();
            ary = obj.convertToArray();
        } else {
            ary = (RubyArray)obj;
        }
        int length = this.getLength();
        if (length != ary.getLength()) {
            return this.getRuntime().getFalse();
        }
        for (long i = 0L; i < (long)length; ++i) {
            if (this.entry(i).callMethod(this.getRuntime().getCurrentContext(), "==", ary.entry(i)).isTrue()) continue;
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    public RubyBoolean eql(IRubyObject obj) {
        RubyArray ary;
        if (!(obj instanceof RubyArray)) {
            return this.getRuntime().getFalse();
        }
        int length = this.getLength();
        if (length != (ary = (RubyArray)obj).getLength()) {
            return this.getRuntime().getFalse();
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (long i = 0L; i < (long)length; ++i) {
            if (this.entry(i).callMethod(context, "eql?", ary.entry(i)).isTrue()) continue;
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().getTrue();
    }

    public IRubyObject compact_bang() {
        this.modify();
        boolean isChanged = false;
        for (int i = this.getLength() - 1; i >= 0; --i) {
            if (!this.entry(i).isNil()) continue;
            this.list.remove(i);
            isChanged = true;
        }
        return isChanged ? this : this.getRuntime().getNil();
    }

    public IRubyObject compact() {
        RubyArray ary = (RubyArray)this.dup();
        ary.compact_bang();
        return ary;
    }

    public IRubyObject empty_p() {
        return this.getLength() == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject rb_clear() {
        this.modify();
        this.list.clear();
        return this;
    }

    public IRubyObject fill(IRubyObject[] args) {
        IRubyObject lenObj;
        IRubyObject begObj;
        IRubyObject filObj;
        int argc;
        int beg = 0;
        int len = this.getLength();
        IRuby runtime = this.getRuntime();
        ThreadContext tc = runtime.getCurrentContext();
        if (tc.isBlockGiven()) {
            argc = this.checkArgumentCount(args, 0, 2);
            filObj = null;
            begObj = argc > 0 ? args[0] : null;
            lenObj = argc > 1 ? args[1] : null;
            ++argc;
        } else {
            argc = this.checkArgumentCount(args, 1, 3);
            filObj = args[0];
            begObj = argc > 1 ? args[1] : null;
            lenObj = argc > 2 ? args[2] : null;
        }
        switch (argc) {
            case 1: {
                break;
            }
            case 2: {
                if (begObj instanceof RubyRange) {
                    long[] begLen = ((RubyRange)begObj).getBeginLength(len, false, true);
                    beg = (int)begLen[0];
                    len = (int)begLen[1];
                    break;
                }
            }
            default: {
                int n = beg = begObj.isNil() ? beg : RubyNumeric.fix2int(begObj);
                if (beg < 0 && (beg += len) < 0) {
                    throw this.getRuntime().newIndexError("Negative array index");
                }
                len -= beg;
                if (argc != 3 || lenObj.isNil()) break;
                len = RubyNumeric.fix2int(lenObj);
            }
        }
        this.modify();
        this.autoExpand(beg + len);
        for (int i = beg; i < beg + len; ++i) {
            if (filObj == null) {
                this.list.set(i, tc.yield(runtime.newFixnum(i)));
                continue;
            }
            this.list.set(i, filObj);
        }
        return this;
    }

    public IRubyObject index(IRubyObject obj) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        int len = this.getLength();
        for (int i = 0; i < len; ++i) {
            if (!this.entry(i).callMethod(context, "==", obj).isTrue()) continue;
            return this.getRuntime().newFixnum(i);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject rindex(IRubyObject obj) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (int i = this.getLength() - 1; i >= 0; --i) {
            if (!this.entry(i).callMethod(context, "==", obj).isTrue()) continue;
            return this.getRuntime().newFixnum(i);
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject indices(IRubyObject[] args) {
        IRubyObject[] result = new IRubyObject[args.length];
        boolean taint = false;
        for (int i = 0; i < args.length; ++i) {
            result[i] = this.entry(RubyNumeric.fix2int(args[i]));
            taint |= result[i].isTaint();
        }
        IRubyObject ary = ((ArrayMetaClass)this.getMetaClass()).create(result);
        ary.setTaint(taint);
        return ary;
    }

    @Override
    public IRubyObject rbClone() {
        RubyArray result = this.getRuntime().newArray(new ArrayList(this.list));
        result.setTaint(this.isTaint());
        result.initCopy(this);
        result.setFrozen(this.isFrozen());
        return result;
    }

    public IRubyObject reverse_bang() {
        this.modify();
        Collections.reverse(this.list);
        return this;
    }

    public IRubyObject reverse() {
        RubyArray result = (RubyArray)this.dup();
        result.reverse_bang();
        return result;
    }

    public RubyArray collect() {
        ThreadContext tc = this.getRuntime().getCurrentContext();
        if (!tc.isBlockGiven()) {
            return (RubyArray)this.dup();
        }
        ArrayList<IRubyObject> ary = new ArrayList<IRubyObject>();
        int len = this.getLength();
        for (int i = 0; i < len; ++i) {
            ary.add(tc.yield(this.entry(i)));
        }
        return new RubyArray(this.getRuntime(), ary);
    }

    public RubyArray collect_bang() {
        this.modify();
        ThreadContext context = this.getRuntime().getCurrentContext();
        int len = this.getLength();
        for (int i = 0; i < len; ++i) {
            this.list.set(i, context.yield(this.entry(i)));
        }
        return this;
    }

    public IRubyObject delete(IRubyObject obj) {
        this.modify();
        ThreadContext tc = this.getRuntime().getCurrentContext();
        IRubyObject result = this.getRuntime().getNil();
        for (int i = this.getLength() - 1; i >= 0; --i) {
            if (!obj.callMethod(tc, "==", this.entry(i)).isTrue()) continue;
            result = (IRubyObject)this.list.remove(i);
        }
        if (result.isNil() && tc.isBlockGiven()) {
            result = tc.yield(this.entry(0L));
        }
        return result;
    }

    public IRubyObject delete_at(IRubyObject obj) {
        this.modify();
        int pos = (int)obj.convertToInteger().getLongValue();
        int len = this.getLength();
        if (pos >= len) {
            return this.getRuntime().getNil();
        }
        return pos < 0 && (pos += len) < 0 ? this.getRuntime().getNil() : (IRubyObject)this.list.remove(pos);
    }

    public IRubyObject reject_bang() {
        this.modify();
        IRubyObject retVal = this.getRuntime().getNil();
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (int i = this.getLength() - 1; i >= 0; --i) {
            if (!context.yield(this.entry(i)).isTrue()) continue;
            retVal = (IRubyObject)this.list.remove(i);
        }
        return retVal.isNil() ? retVal : this;
    }

    public IRubyObject delete_if() {
        this.reject_bang();
        return this;
    }

    public IRubyObject replace(IRubyObject other) {
        this.replace(0L, this.getLength(), other.convertToArray());
        return this;
    }

    public IRubyObject op_cmp(IRubyObject other) {
        RubyArray ary = other.convertToArray();
        int otherLen = ary.getLength();
        int len = this.getLength();
        int minCommon = Math.min(len, otherLen);
        ThreadContext context = this.getRuntime().getCurrentContext();
        RubyClass fixnumClass = this.getRuntime().getClass("Fixnum");
        for (int i = 0; i < minCommon; ++i) {
            IRubyObject result = this.entry(i).callMethod(context, "<=>", ary.entry(i));
            if (result.isKindOf(fixnumClass) && RubyFixnum.fix2int(result) == 0) continue;
            return result;
        }
        if (len != otherLen) {
            return len < otherLen ? RubyFixnum.minus_one(this.getRuntime()) : RubyFixnum.one(this.getRuntime());
        }
        return RubyFixnum.zero(this.getRuntime());
    }

    public IRubyObject slice_bang(IRubyObject[] args) {
        int argc = this.checkArgumentCount(args, 1, 2);
        IRubyObject result = this.aref(args);
        if (argc == 2) {
            long beg = RubyNumeric.fix2long(args[0]);
            long len = RubyNumeric.fix2long(args[1]);
            this.replace(beg, len, this.getRuntime().getNil());
        } else if (args[0] instanceof RubyFixnum && RubyNumeric.fix2long(args[0]) < (long)this.getLength()) {
            this.replace(RubyNumeric.fix2long(args[0]), 1L, this.getRuntime().getNil());
        } else if (args[0] instanceof RubyRange) {
            long[] begLen = ((RubyRange)args[0]).getBeginLength(this.getLength(), false, true);
            this.replace(begLen[0], begLen[1], this.getRuntime().getNil());
        }
        return result;
    }

    public IRubyObject assoc(IRubyObject arg) {
        int len = this.getLength();
        for (int i = 0; i < len; ++i) {
            if (!(this.entry(i) instanceof RubyArray) || ((RubyArray)this.entry(i)).getLength() <= 0) continue;
            RubyArray ary = (RubyArray)this.entry(i);
            if (!arg.callMethod(this.getRuntime().getCurrentContext(), "==", ary.entry(0L)).isTrue()) continue;
            return ary;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject rassoc(IRubyObject arg) {
        ThreadContext context = this.getRuntime().getCurrentContext();
        int len = this.getLength();
        for (int i = 0; i < len; ++i) {
            RubyArray ary;
            if (!(this.entry(i) instanceof RubyArray) || ((RubyArray)this.entry(i)).getLength() <= 1 || !arg.callMethod(context, "==", (ary = (RubyArray)this.entry(i)).entry(1L)).isTrue()) continue;
            return ary;
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject flatten_bang() {
        this.modify();
        return this.flatten(this.list) ? this : this.getRuntime().getNil();
    }

    public IRubyObject flatten() {
        RubyArray rubyArray = (RubyArray)this.dup();
        rubyArray.flatten_bang();
        return rubyArray;
    }

    public IRubyObject nitems() {
        int count = 0;
        int len = this.getLength();
        for (int i = 0; i < len; ++i) {
            count += this.entry(i).isNil() ? 0 : 1;
        }
        return this.getRuntime().newFixnum(count);
    }

    public IRubyObject op_plus(IRubyObject other) {
        List otherList = other.convertToArray().getList();
        ArrayList newList = new ArrayList(this.getLength() + otherList.size());
        newList.addAll(this.list);
        newList.addAll(otherList);
        return new RubyArray(this.getRuntime(), newList);
    }

    public IRubyObject op_times(IRubyObject arg) {
        if (arg instanceof RubyString) {
            return this.join((RubyString)arg);
        }
        int len = (int)arg.convertToInteger().getLongValue();
        if (len < 0) {
            throw this.getRuntime().newArgumentError("negative argument");
        }
        ArrayList newList = new ArrayList(this.getLength() * len);
        for (int i = 0; i < len; ++i) {
            newList.addAll(this.list);
        }
        return new RubyArray(this.getRuntime(), newList);
    }

    private static ArrayList uniq(List oldList) {
        ArrayList newList = new ArrayList(oldList.size());
        HashSet passed = new HashSet(oldList.size());
        for (Object item : oldList) {
            if (passed.contains(item)) continue;
            passed.add(item);
            newList.add(item);
        }
        newList.trimToSize();
        return newList;
    }

    public IRubyObject uniq_bang() {
        this.modify();
        ArrayList newList = RubyArray.uniq(this.list);
        if (newList.equals(this.list)) {
            return this.getRuntime().getNil();
        }
        this.list = newList;
        return this;
    }

    public IRubyObject uniq() {
        return new RubyArray(this.getRuntime(), RubyArray.uniq(this.list));
    }

    public IRubyObject op_diff(IRubyObject other) {
        ArrayList ary1 = new ArrayList(this.list);
        List ary2 = other.convertToArray().getList();
        int len2 = ary2.size();
        ThreadContext context = this.getRuntime().getCurrentContext();
        block0: for (int i = ary1.size() - 1; i >= 0; --i) {
            IRubyObject obj = (IRubyObject)ary1.get(i);
            for (int j = 0; j < len2; ++j) {
                if (!obj.callMethod(context, "==", (IRubyObject)ary2.get(j)).isTrue()) continue;
                ary1.remove(i);
                continue block0;
            }
        }
        return new RubyArray(this.getRuntime(), ary1);
    }

    public IRubyObject op_and(IRubyObject other) {
        RubyClass arrayClass = this.getRuntime().getClass("Array");
        if (!other.isKindOf(arrayClass)) {
            throw this.getRuntime().newTypeError(other, arrayClass);
        }
        ArrayList ary1 = RubyArray.uniq(this.list);
        int len1 = ary1.size();
        List ary2 = other.convertToArray().getList();
        int len2 = ary2.size();
        ArrayList<IRubyObject> ary3 = new ArrayList<IRubyObject>(len1);
        ThreadContext context = this.getRuntime().getCurrentContext();
        block0: for (int i = 0; i < len1; ++i) {
            IRubyObject obj = (IRubyObject)ary1.get(i);
            for (int j = 0; j < len2; ++j) {
                if (!obj.callMethod(context, "eql?", (IRubyObject)ary2.get(j)).isTrue()) continue;
                ary3.add(obj);
                continue block0;
            }
        }
        ary3.trimToSize();
        return new RubyArray(this.getRuntime(), ary3);
    }

    public IRubyObject op_or(IRubyObject other) {
        ArrayList newArray = new ArrayList(this.list);
        newArray.addAll(other.convertToArray().getList());
        return new RubyArray(this.getRuntime(), RubyArray.uniq(newArray));
    }

    public RubyArray sort() {
        RubyArray rubyArray = (RubyArray)this.dup();
        rubyArray.sort_bang();
        return rubyArray;
    }

    public IRubyObject sort_bang() {
        this.modify();
        this.setTmpLock(true);
        Comparator comparator = this.getRuntime().getCurrentContext().isBlockGiven() ? new BlockComparator() : new DefaultComparator();
        Collections.sort(this.list, comparator);
        this.setTmpLock(false);
        return this;
    }

    @Override
    public void marshalTo(MarshalStream output) throws IOException {
        output.write(91);
        output.dumpInt(this.getList().size());
        Iterator iter = this.getList().iterator();
        while (iter.hasNext()) {
            output.dumpObject((IRubyObject)iter.next());
        }
    }

    public static RubyArray unmarshalFrom(UnmarshalStream input) throws IOException {
        RubyArray result = input.getRuntime().newArray();
        input.registerLinkTarget(result);
        int size = input.unmarshalInt();
        for (int i = 0; i < size; ++i) {
            result.append(input.unmarshalObject());
        }
        return result;
    }

    public RubyString pack(IRubyObject obj) {
        RubyString iFmt = RubyString.objAsString(obj);
        return Pack.pack(this.list, iFmt);
    }

    @Override
    public Class getJavaClass() {
        return List.class;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    @Override
    public boolean contains(Object element) {
        return this.list.contains(JavaUtil.convertJavaToRuby(this.getRuntime(), element));
    }

    @Override
    public Iterator iterator() {
        return new ConversionIterator(this.list.iterator());
    }

    @Override
    public Object[] toArray() {
        Object[] array = new Object[this.getLength()];
        Iterator iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    @Override
    public Object[] toArray(Object[] arg) {
        Object[] array = arg;
        int length = this.getLength();
        if (array.length < length) {
            Class<?> type = array.getClass().getComponentType();
            array = (Object[])Array.newInstance(type, length);
        }
        Iterator iter = this.iterator();
        int i = 0;
        while (iter.hasNext()) {
            array[i] = iter.next();
            ++i;
        }
        return array;
    }

    @Override
    public boolean add(Object element) {
        return this.list.add(JavaUtil.convertJavaToRuby(this.getRuntime(), element));
    }

    @Override
    public boolean remove(Object element) {
        return this.list.remove(JavaUtil.convertJavaToRuby(this.getRuntime(), element));
    }

    @Override
    public boolean containsAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (this.indexOf(iter.next()) != -1) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection c) {
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            this.add(iter.next());
        }
        return !c.isEmpty();
    }

    public boolean addAll(int index, Collection c) {
        Iterator iter = c.iterator();
        int i = index;
        while (iter.hasNext()) {
            this.add(i, iter.next());
            ++i;
        }
        return !c.isEmpty();
    }

    @Override
    public boolean removeAll(Collection c) {
        boolean changed = false;
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            if (!this.remove(iter.next())) continue;
            changed = true;
        }
        return changed;
    }

    @Override
    public boolean retainAll(Collection c) {
        boolean listChanged = false;
        for (Object element : this) {
            if (c.contains(element)) continue;
            this.remove(element);
            listChanged = true;
        }
        return listChanged;
    }

    public Object get(int index) {
        return JavaUtil.convertRubyToJava((IRubyObject)this.list.get(index), Object.class);
    }

    public Object set(int index, Object element) {
        return this.list.set(index, JavaUtil.convertJavaToRuby(this.getRuntime(), element));
    }

    public void add(int index, Object element) {
        this.list.add(index, JavaUtil.convertJavaToRuby(this.getRuntime(), element));
    }

    public Object remove(int index) {
        return JavaUtil.convertRubyToJava((IRubyObject)this.list.remove(index), Object.class);
    }

    @Override
    public int indexOf(Object element) {
        return this.list.indexOf(JavaUtil.convertJavaToRuby(this.getRuntime(), element));
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.list.lastIndexOf(JavaUtil.convertJavaToRuby(this.getRuntime(), element));
    }

    public ListIterator listIterator() {
        return new ConversionListIterator(this.list.listIterator());
    }

    public ListIterator listIterator(int index) {
        return new ConversionListIterator(this.list.listIterator(index));
    }

    public List subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || toIndex > this.size() || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException();
        }
        IRubyObject subList = this.subseq(fromIndex, toIndex - fromIndex + 1);
        return subList.isNil() ? null : (List)((Object)subList);
    }

    @Override
    public void clear() {
        this.list.clear();
    }

    class ConversionListIterator
    implements ListIterator {
        private ListIterator iterator;

        public ConversionListIterator(ListIterator iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Object next() {
            return JavaUtil.convertRubyToJava((IRubyObject)this.iterator.next(), Object.class);
        }

        @Override
        public boolean hasPrevious() {
            return this.iterator.hasPrevious();
        }

        public Object previous() {
            return JavaUtil.convertRubyToJava((IRubyObject)this.iterator.previous(), Object.class);
        }

        @Override
        public int nextIndex() {
            return this.iterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterator.previousIndex();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }

        public void set(Object arg0) {
        }

        public void add(Object arg0) {
        }
    }

    static class DefaultComparator
    implements Comparator {
        DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            IRubyObject obj1 = (IRubyObject)o1;
            IRubyObject obj2 = (IRubyObject)o2;
            if (o1 instanceof RubyFixnum && o2 instanceof RubyFixnum) {
                long diff = RubyNumeric.fix2long(obj1) - RubyNumeric.fix2long(obj2);
                return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
            }
            if (o1 instanceof RubyString && o2 instanceof RubyString) {
                StringMetaClass stringMC = (StringMetaClass)((RubyObject)o1).getMetaClass();
                return RubyNumeric.fix2int(stringMC.op_cmp.call(stringMC.getRuntime().getCurrentContext(), (RubyString)o1, stringMC, "<=>", new IRubyObject[]{(RubyString)o2}, false));
            }
            return RubyNumeric.fix2int(obj1.callMethod(obj1.getRuntime().getCurrentContext(), "<=>", obj2));
        }
    }

    class BlockComparator
    implements Comparator {
        BlockComparator() {
        }

        public int compare(Object o1, Object o2) {
            IRubyObject result = RubyArray.this.getRuntime().getCurrentContext().yieldCurrentBlock(RubyArray.this.getRuntime().newArray((IRubyObject)o1, (IRubyObject)o2), null, null, true);
            return (int)((RubyNumeric)result).getLongValue();
        }
    }
}

