/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.math.BigDecimal;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyBigDecimal
extends RubyNumeric {
    private BigDecimal value;

    public static RubyClass createBigDecimal(IRuby runtime) {
        RubyClass result = runtime.defineClass("BigDecimal", runtime.getClass("Numeric"));
        result.setConstant("ROUND_DOWN", RubyNumeric.int2fix(runtime, 1L));
        result.setConstant("SIGN_POSITIVE_INFINITE", RubyNumeric.int2fix(runtime, 3L));
        result.setConstant("EXCEPTION_OVERFLOW", RubyNumeric.int2fix(runtime, 1L));
        result.setConstant("SIGN_POSITIVE_ZERO", RubyNumeric.int2fix(runtime, 1L));
        result.setConstant("EXCEPTION_ALL", RubyNumeric.int2fix(runtime, 255L));
        result.setConstant("ROUND_CEILING", RubyNumeric.int2fix(runtime, 2L));
        result.setConstant("ROUND_UP", RubyNumeric.int2fix(runtime, 0L));
        result.setConstant("SIGN_NEGATIVE_FINITE", RubyNumeric.int2fix(runtime, -2L));
        result.setConstant("EXCEPTION_UNDERFLOW", RubyNumeric.int2fix(runtime, 4L));
        result.setConstant("SIGN_NaN", RubyNumeric.int2fix(runtime, 0L));
        result.setConstant("BASE", RubyNumeric.int2fix(runtime, 10000L));
        result.setConstant("ROUND_HALF_DOWN", RubyNumeric.int2fix(runtime, 5L));
        result.setConstant("ROUND_MODE", RubyNumeric.int2fix(runtime, 256L));
        result.setConstant("SIGN_POSITIVE_FINITE", RubyNumeric.int2fix(runtime, 2L));
        result.setConstant("EXCEPTION_INFINITY", RubyNumeric.int2fix(runtime, 1L));
        result.setConstant("ROUND_HALF_EVEN", RubyNumeric.int2fix(runtime, 6L));
        result.setConstant("ROUND_HALF_UP", RubyNumeric.int2fix(runtime, 4L));
        result.setConstant("SIGN_NEGATIVE_INFINITE", RubyNumeric.int2fix(runtime, -3L));
        result.setConstant("EXCEPTION_ZERODIVIDE", RubyNumeric.int2fix(runtime, 1L));
        result.setConstant("SIGN_NEGATIVE_ZERO", RubyNumeric.int2fix(runtime, -1L));
        result.setConstant("EXCEPTION_NaN", RubyNumeric.int2fix(runtime, 2L));
        result.setConstant("ROUND_FLOOR", RubyNumeric.int2fix(runtime, 3L));
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyBigDecimal.class);
        runtime.getModule("Kernel").defineModuleFunction("BigDecimal", callbackFactory.getOptSingletonMethod("newCreate"));
        result.defineSingletonMethod("new", callbackFactory.getOptSingletonMethod("newCreate"));
        result.defineSingletonMethod("ver", callbackFactory.getSingletonMethod("ver"));
        result.defineSingletonMethod("_load", callbackFactory.getSingletonMethod("_load", IRubyObject.class));
        result.defineSingletonMethod("double_fig", callbackFactory.getSingletonMethod("double_fig"));
        result.defineSingletonMethod("limit", callbackFactory.getSingletonMethod("limit", RubyFixnum.class));
        result.defineSingletonMethod("mode", callbackFactory.getSingletonMethod("mode", RubyFixnum.class, RubyFixnum.class));
        result.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
        result.defineMethod("%", callbackFactory.getMethod("mod", IRubyObject.class));
        result.defineMethod("modulo", callbackFactory.getMethod("mod", IRubyObject.class));
        result.defineMethod("*", callbackFactory.getOptMethod("mult"));
        result.defineMethod("mult", callbackFactory.getOptMethod("mult"));
        result.defineMethod("**", callbackFactory.getMethod("power", RubyInteger.class));
        result.defineMethod("power", callbackFactory.getMethod("power", RubyInteger.class));
        result.defineMethod("+", callbackFactory.getOptMethod("add"));
        result.defineMethod("add", callbackFactory.getOptMethod("add"));
        result.defineMethod("-", callbackFactory.getOptMethod("sub"));
        result.defineMethod("sub", callbackFactory.getOptMethod("sub"));
        result.defineMethod("/", callbackFactory.getOptMethod("div"));
        result.defineMethod("div", callbackFactory.getOptMethod("div"));
        result.defineMethod("quo", callbackFactory.getOptMethod("div"));
        result.defineMethod("<=>", callbackFactory.getMethod("spaceship", IRubyObject.class));
        result.defineMethod("==", callbackFactory.getMethod("eql_p", IRubyObject.class));
        result.defineMethod("===", callbackFactory.getMethod("eql_p", IRubyObject.class));
        result.defineMethod("eql?", callbackFactory.getMethod("eql_p", IRubyObject.class));
        result.defineMethod("!=", callbackFactory.getMethod("ne", IRubyObject.class));
        result.defineMethod("<", callbackFactory.getMethod("lt", IRubyObject.class));
        result.defineMethod("<=", callbackFactory.getMethod("le", IRubyObject.class));
        result.defineMethod(">", callbackFactory.getMethod("gt", IRubyObject.class));
        result.defineMethod(">=", callbackFactory.getMethod("ge", IRubyObject.class));
        result.defineMethod("abs", callbackFactory.getMethod("abs"));
        result.defineMethod("ceil", callbackFactory.getMethod("ceil", RubyInteger.class));
        result.defineMethod("coerce", callbackFactory.getMethod("coerce", IRubyObject.class));
        result.defineMethod("divmod", callbackFactory.getMethod("divmod", IRubyObject.class));
        result.defineMethod("exponent", callbackFactory.getMethod("exponent"));
        result.defineMethod("finite?", callbackFactory.getMethod("finite_p"));
        result.defineMethod("fix", callbackFactory.getMethod("fix"));
        result.defineMethod("floor", callbackFactory.getMethod("floor", RubyInteger.class));
        result.defineMethod("frac", callbackFactory.getMethod("frac"));
        result.defineMethod("infinite?", callbackFactory.getMethod("infinite_p"));
        result.defineMethod("inspect", callbackFactory.getMethod("inspect"));
        result.defineMethod("nan?", callbackFactory.getMethod("nan_p"));
        result.defineMethod("nonzero?", callbackFactory.getMethod("nonzero_p"));
        result.defineMethod("precs", callbackFactory.getMethod("precs"));
        result.defineMethod("remainder", callbackFactory.getMethod("remainder", IRubyObject.class));
        result.defineMethod("round", callbackFactory.getOptMethod("round"));
        result.defineMethod("sign", callbackFactory.getMethod("sign"));
        result.defineMethod("split", callbackFactory.getMethod("split"));
        result.defineMethod("sqrt", callbackFactory.getOptMethod("sqrt"));
        result.defineMethod("to_f", callbackFactory.getMethod("to_f"));
        result.defineMethod("to_i", callbackFactory.getMethod("to_i"));
        result.defineMethod("to_int", callbackFactory.getMethod("to_int"));
        result.defineMethod("to_s", callbackFactory.getOptMethod("to_s"));
        result.defineMethod("truncate", callbackFactory.getOptMethod("truncate"));
        result.defineMethod("zero?", callbackFactory.getMethod("zero_p"));
        return result;
    }

    public RubyBigDecimal(IRuby runtime) {
        this(runtime, new BigDecimal("0"));
    }

    public RubyBigDecimal(IRuby runtime, BigDecimal value) {
        super(runtime, runtime.getClass("BigDecimal"));
        this.value = value;
    }

    public static RubyBigDecimal newCreate(IRubyObject recv, IRubyObject[] args) {
        RubyBigDecimal result = new RubyBigDecimal(recv.getRuntime());
        result.callInit(args);
        return result;
    }

    public static IRubyObject ver(IRubyObject recv) {
        return recv.getRuntime().newString("1.0.1");
    }

    public static IRubyObject _load(IRubyObject recv, IRubyObject p1) {
        return null;
    }

    public static IRubyObject double_fig(IRubyObject recv) {
        return recv.getRuntime().newFixnum(20L);
    }

    public static IRubyObject limit(IRubyObject recv, RubyFixnum p1) {
        return null;
    }

    public static IRubyObject mode(IRubyObject recv, RubyFixnum mode, RubyFixnum value) {
        return null;
    }

    @Override
    public IRubyObject initialize(IRubyObject[] args) {
        this.value = new BigDecimal(args[0].toString());
        return this;
    }

    public IRubyObject mod(IRubyObject arg) {
        return this;
    }

    public IRubyObject mult(IRubyObject[] args) {
        RubyBigDecimal val = null;
        val = args[0] instanceof RubyBigDecimal ? (RubyBigDecimal)args[0] : (RubyBigDecimal)args[0].callMethod(this.getRuntime().getCurrentContext(), "to_d");
        return new RubyBigDecimal(this.getRuntime(), this.value.multiply(val.value));
    }

    public IRubyObject power(RubyInteger arg) {
        BigDecimal val = this.value;
        int j = RubyNumeric.fix2int(arg);
        for (int i = 0; i < j; ++i) {
            val = val.multiply(val);
        }
        return new RubyBigDecimal(this.getRuntime(), val);
    }

    public IRubyObject add(IRubyObject[] args) {
        RubyBigDecimal val = null;
        val = args[0] instanceof RubyBigDecimal ? (RubyBigDecimal)args[0] : (RubyBigDecimal)args[0].callMethod(this.getRuntime().getCurrentContext(), "to_d");
        return new RubyBigDecimal(this.getRuntime(), this.value.add(val.value));
    }

    public IRubyObject sub(IRubyObject[] args) {
        RubyBigDecimal val = null;
        val = args[0] instanceof RubyBigDecimal ? (RubyBigDecimal)args[0] : (RubyBigDecimal)args[0].callMethod(this.getRuntime().getCurrentContext(), "to_d");
        return new RubyBigDecimal(this.getRuntime(), this.value.subtract(val.value));
    }

    public IRubyObject div(IRubyObject[] args) {
        RubyBigDecimal val = null;
        val = args[0] instanceof RubyBigDecimal ? (RubyBigDecimal)args[0] : (RubyBigDecimal)args[0].callMethod(this.getRuntime().getCurrentContext(), "to_d");
        return new RubyBigDecimal(this.getRuntime(), this.value.divide(val.value, 6));
    }

    private IRubyObject cmp(IRubyObject r, char op) {
        int e = 0;
        if (!(r instanceof RubyBigDecimal)) {
            e = RubyNumeric.fix2int(this.callCoerced("<=>", r));
        } else {
            RubyBigDecimal rb = (RubyBigDecimal)r;
            e = this.value.compareTo(rb.value);
        }
        switch (op) {
            case '*': {
                return this.getRuntime().newFixnum(e);
            }
            case '=': {
                return e == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '!': {
                return e != 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'G': {
                return e >= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '>': {
                return e > 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'L': {
                return e <= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '<': {
                return e < 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
        }
        return this.getRuntime().getNil();
    }

    public IRubyObject spaceship(IRubyObject arg) {
        return this.cmp(arg, '*');
    }

    public IRubyObject eql_p(IRubyObject arg) {
        return this.cmp(arg, '=');
    }

    public IRubyObject ne(IRubyObject arg) {
        return this.cmp(arg, '!');
    }

    public IRubyObject lt(IRubyObject arg) {
        return this.cmp(arg, '<');
    }

    public IRubyObject le(IRubyObject arg) {
        return this.cmp(arg, 'L');
    }

    public IRubyObject gt(IRubyObject arg) {
        return this.cmp(arg, '>');
    }

    public IRubyObject ge(IRubyObject arg) {
        return this.cmp(arg, 'G');
    }

    @Override
    public RubyNumeric abs() {
        return new RubyBigDecimal(this.getRuntime(), this.value.abs());
    }

    public IRubyObject ceil(RubyInteger arg) {
        return this;
    }

    @Override
    public IRubyObject coerce(IRubyObject other) {
        RubyArray obj = other instanceof RubyFloat ? this.getRuntime().newArray(other, this.to_f()) : this.getRuntime().newArray(RubyBigDecimal.newCreate(other, new IRubyObject[]{other.callMethod(this.getRuntime().getCurrentContext(), "to_s")}), this);
        return obj;
    }

    @Override
    public double getDoubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public long getLongValue() {
        return this.value.longValue();
    }

    @Override
    public IRubyObject divmod(IRubyObject arg) {
        return this.getRuntime().getNil();
    }

    public IRubyObject exponent() {
        BigDecimal abs = this.value.abs();
        String unscaled = abs.unscaledValue().toString();
        int exponent = abs.toString().indexOf(46);
        return this.getRuntime().newFixnum(exponent);
    }

    public IRubyObject finite_p() {
        return this.getRuntime().getTrue();
    }

    public IRubyObject fix() {
        return this;
    }

    public IRubyObject floor(RubyInteger arg) {
        return this;
    }

    public IRubyObject frac() {
        return this;
    }

    public IRubyObject infinite_p() {
        return this.getRuntime().getFalse();
    }

    @Override
    public IRubyObject inspect() {
        StringBuffer val = new StringBuffer("#<BigDecimal:").append(Integer.toHexString(System.identityHashCode(this))).append(",");
        val.append("'").append(this.callMethod(this.getRuntime().getCurrentContext(), "to_s")).append("'").append(",");
        int len = this.value.abs().unscaledValue().toString().length();
        int pow = len / 4;
        val.append(len).append("(").append((pow + 1) * 4).append(")").append(">");
        return this.getRuntime().newString(val.toString());
    }

    public IRubyObject nan_p() {
        return this.getRuntime().getFalse();
    }

    @Override
    public IRubyObject nonzero_p() {
        return this.value.signum() != 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }

    public IRubyObject precs() {
        return this.getRuntime().getNil();
    }

    @Override
    public IRubyObject remainder(IRubyObject arg) {
        return this;
    }

    public IRubyObject round(IRubyObject[] args) {
        return this;
    }

    public IRubyObject sign() {
        return this.getRuntime().newFixnum(this.value.signum());
    }

    public IRubyObject split() {
        return this.getRuntime().getNil();
    }

    public IRubyObject sqrt(IRubyObject[] args) {
        return new RubyBigDecimal(this.getRuntime(), new BigDecimal(Math.sqrt(this.value.doubleValue())));
    }

    public IRubyObject to_f() {
        return RubyFloat.newFloat(this.getRuntime(), this.value.doubleValue());
    }

    public IRubyObject to_i() {
        return RubyNumeric.int2fix(this.getRuntime(), this.value.longValue());
    }

    @Override
    public IRubyObject to_int() {
        return RubyNumeric.int2fix(this.getRuntime(), this.value.longValue());
    }

    public IRubyObject to_s(IRubyObject[] args) {
        boolean engineering = true;
        boolean pos_sign = false;
        boolean pos_space = false;
        int groups = 0;
        if (args.length != 0 && !args[0].isNil()) {
            String format = args[0].toString();
            int start = 0;
            int end = format.length();
            if (format.length() > 0 && format.charAt(0) == '+') {
                pos_sign = true;
                ++start;
            } else if (format.length() > 0 && format.charAt(0) == ' ') {
                pos_sign = true;
                pos_space = true;
                ++start;
            }
            if (format.length() > 0 && format.charAt(format.length() - 1) == 'F') {
                engineering = false;
                --end;
            } else if (format.length() > 0 && format.charAt(format.length() - 1) == 'E') {
                engineering = true;
                --end;
            }
            String nums = format.substring(start, end);
            if (nums.length() > 0) {
                groups = Integer.parseInt(nums);
            }
        }
        String out = null;
        if (engineering) {
            BigDecimal abs = this.value.abs();
            String unscaled = abs.unscaledValue().toString();
            int exponent = abs.toString().indexOf(46);
            if (-1 == exponent) {
                exponent = abs.toString().length();
            }
            int signum = this.value.signum();
            StringBuffer build = new StringBuffer();
            build.append(signum == -1 ? "-" : (signum == 1 ? (pos_sign ? (pos_space ? " " : "+") : "") : ""));
            build.append("0.");
            if (0 == groups) {
                build.append(unscaled);
            } else {
                String sep = "";
                for (int index = 0; index < unscaled.length(); index += groups) {
                    int next = index + groups;
                    if (next > unscaled.length()) {
                        next = unscaled.length();
                    }
                    build.append(sep).append(unscaled.substring(index, next));
                    sep = " ";
                }
            }
            build.append("E").append(exponent);
            out = build.toString();
        } else {
            BigDecimal abs = this.value.abs();
            String unscaled = abs.unscaledValue().toString();
            int ix = abs.toString().indexOf(46);
            String whole = unscaled;
            String after = null;
            if (ix != -1) {
                whole = unscaled.substring(0, ix);
                after = unscaled.substring(ix + 1);
            }
            int signum = this.value.signum();
            StringBuffer build = new StringBuffer();
            build.append(signum == -1 ? "-" : (signum == 1 ? (pos_sign ? (pos_space ? " " : "+") : "") : ""));
            if (0 == groups) {
                build.append(whole);
                if (null != after) {
                    build.append(".").append(after);
                }
            } else {
                int next;
                int index;
                String sep = "";
                for (index = 0; index < whole.length(); index += groups) {
                    next = index + groups;
                    if (next > whole.length()) {
                        next = whole.length();
                    }
                    build.append(sep).append(whole.substring(index, next));
                    sep = " ";
                }
                if (null != after) {
                    build.append(".");
                    sep = "";
                    for (index = 0; index < after.length(); index += groups) {
                        next = index + groups;
                        if (next > after.length()) {
                            next = after.length();
                        }
                        build.append(sep).append(after.substring(index, next));
                        sep = " ";
                    }
                }
            }
            out = build.toString();
        }
        return this.getRuntime().newString(out);
    }

    public IRubyObject truncate(IRubyObject[] args) {
        return this;
    }

    @Override
    public RubyBoolean zero_p() {
        return this.value.signum() == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
    }
}

