/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.HashMap;
import org.jruby.IRuby;
import org.jruby.MetaClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalStream;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.collections.SinglyLinkedList;

public class RubyClass
extends RubyModule {
    private final IRuby runtime;

    protected RubyClass(RubyClass superClass) {
        super(superClass.getRuntime(), superClass.getRuntime().getClass("Class"), superClass, null, null);
        this.infectBy(superClass);
        this.runtime = superClass.getRuntime();
    }

    protected RubyClass(IRuby runtime, RubyClass superClass) {
        super(runtime, null, superClass, null, null);
        this.runtime = runtime;
    }

    protected RubyClass(IRuby runtime, RubyClass metaClass, RubyClass superClass) {
        super(runtime, metaClass, superClass, null, null);
        this.runtime = runtime;
    }

    protected RubyClass(IRuby runtime, RubyClass metaClass, RubyClass superClass, SinglyLinkedList parentCRef, String name) {
        super(runtime, metaClass, superClass, parentCRef, name);
        this.runtime = runtime;
    }

    @Override
    public IRuby getRuntime() {
        return this.runtime;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return true;
    }

    public static void createClassClass(RubyClass classClass) {
        CallbackFactory callbackFactory = classClass.getRuntime().callbackFactory(RubyClass.class);
        classClass.defineSingletonMethod("new", callbackFactory.getOptSingletonMethod("newClass"));
        classClass.defineMethod("allocate", callbackFactory.getMethod("allocate"));
        classClass.defineMethod("new", callbackFactory.getOptMethod("newInstance"));
        classClass.defineMethod("superclass", callbackFactory.getMethod("superclass"));
        classClass.defineSingletonMethod("inherited", callbackFactory.getSingletonMethod("inherited", IRubyObject.class));
        classClass.undefineMethod("module_function");
    }

    public static IRubyObject inherited(IRubyObject recv, IRubyObject arg) {
        return recv.getRuntime().getNil();
    }

    public void inheritedBy(RubyClass superType) {
        if (superType == null) {
            superType = this.getRuntime().getObject();
        }
        superType.callMethod(this.getRuntime().getCurrentContext(), "inherited", this);
    }

    public RubyClass getSingletonClassClone() {
        if (!this.isSingleton()) {
            return this;
        }
        MetaClass clone = new MetaClass(this.getRuntime(), this.getMetaClass(), this.getSuperClass().getCRef());
        clone.initCopy(this);
        clone.setInstanceVariables(new HashMap(this.getInstanceVariables()));
        return (RubyClass)this.cloneMethods(clone);
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public RubyClass getMetaClass() {
        RubyClass type = super.getMetaClass();
        return type != null ? type : this.getRuntime().getClass("Class");
    }

    public RubyClass getRealClass() {
        return this;
    }

    public MetaClass newSingletonClass(SinglyLinkedList parentCRef) {
        MetaClass newClass = new MetaClass(this.getRuntime(), this, parentCRef);
        newClass.infectBy(this);
        return newClass;
    }

    public static RubyClass newClass(IRuby runtime, RubyClass superClass, SinglyLinkedList parentCRef, String name) {
        return new RubyClass(runtime, runtime.getClass("Class"), superClass, parentCRef, name);
    }

    protected RubyClass subclass() {
        if (this == this.getRuntime().getClass("Class")) {
            throw this.getRuntime().newTypeError("can't make subclass of Class");
        }
        return new RubyClass(this);
    }

    public IRubyObject newInstance(IRubyObject[] args) {
        IRubyObject obj = this.allocate();
        obj.callInit(args);
        return obj;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RubyClass newClass(IRubyObject recv, IRubyObject[] args) {
        RubyClass superClass;
        IRuby runtime = recv.getRuntime();
        if (args.length > 0) {
            if (!(args[0] instanceof RubyClass)) throw runtime.newTypeError("wrong argument type " + args[0].getType().getName() + " (expected Class)");
            superClass = (RubyClass)args[0];
        } else {
            superClass = runtime.getObject();
        }
        ThreadContext tc = runtime.getCurrentContext();
        RubyClass newClass = superClass.newSubClass(null, tc.peekCRef());
        newClass.callInit(args);
        newClass.inheritedBy(superClass);
        if (!tc.isBlockGiven()) return newClass;
        tc.yieldCurrentBlock(null, newClass, newClass, false);
        return newClass;
    }

    public IRubyObject superclass() {
        RubyClass superClass;
        for (superClass = this.getSuperClass(); superClass != null && superClass.isIncluded(); superClass = superClass.getSuperClass()) {
        }
        return superClass != null ? superClass : this.getRuntime().getNil();
    }

    public static IRubyObject inherited(RubyClass recv) {
        throw recv.getRuntime().newTypeError("can't make subclass of Class");
    }

    @Override
    public void marshalTo(MarshalStream output) throws IOException {
        output.write(99);
        output.dumpString(this.getName());
    }

    public static RubyModule unmarshalFrom(UnmarshalStream output) throws IOException {
        return (RubyClass)RubyModule.unmarshalFrom(output);
    }

    public IRubyObject allocate() {
        IRubyObject newObject = this.allocateObject();
        if (newObject.getType() != this.getRealClass()) {
            throw this.getRuntime().newTypeError("wrong instance allocation");
        }
        return newObject;
    }

    protected IRubyObject allocateObject() {
        RubyObject newObject = new RubyObject(this.runtime, this);
        return newObject;
    }

    public RubyClass newSubClass(String name, SinglyLinkedList parentCRef) {
        RubyClass classClass = this.runtime.getClass("Class");
        if (this == classClass) {
            throw this.runtime.newTypeError("can't make subclass of Class");
        }
        if (this instanceof MetaClass) {
            throw this.runtime.newTypeError("can't make subclass of virtual class");
        }
        RubyClass newClass = new RubyClass(this.runtime, classClass, this, parentCRef, name);
        newClass.makeMetaClass(this.getMetaClass(), newClass.getCRef());
        newClass.inheritedBy(this);
        if (null != name) {
            ((RubyModule)parentCRef.getValue()).setConstant(name, newClass);
        }
        return newClass;
    }

    @Override
    protected IRubyObject doClone() {
        return RubyClass.newClass(this.getRuntime(), this.getSuperClass(), null, this.getBaseName());
    }
}

