/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Glob;
import org.jruby.util.JRubyFile;

public class RubyDir
extends RubyObject {
    private RubyString path;
    protected JRubyFile dir;
    private String[] snapshot;
    private int pos;
    private boolean isOpen = true;

    public RubyDir(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    public static RubyClass createDirClass(IRuby runtime) {
        RubyClass dirClass = runtime.defineClass("Dir", runtime.getObject());
        dirClass.includeModule(runtime.getModule("Enumerable"));
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyDir.class);
        dirClass.defineSingletonMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
        dirClass.defineSingletonMethod("glob", callbackFactory.getSingletonMethod("glob", RubyString.class));
        dirClass.defineSingletonMethod("entries", callbackFactory.getSingletonMethod("entries", RubyString.class));
        dirClass.defineSingletonMethod("[]", callbackFactory.getSingletonMethod("glob", RubyString.class));
        dirClass.defineSingletonMethod("chdir", callbackFactory.getOptSingletonMethod("chdir"));
        dirClass.defineSingletonMethod("chroot", callbackFactory.getSingletonMethod("chroot", RubyString.class));
        dirClass.defineSingletonMethod("foreach", callbackFactory.getSingletonMethod("foreach", RubyString.class));
        dirClass.defineSingletonMethod("getwd", callbackFactory.getSingletonMethod("getwd"));
        dirClass.defineSingletonMethod("pwd", callbackFactory.getSingletonMethod("getwd"));
        dirClass.defineSingletonMethod("mkdir", callbackFactory.getOptSingletonMethod("mkdir"));
        dirClass.defineSingletonMethod("open", callbackFactory.getSingletonMethod("open", RubyString.class));
        dirClass.defineSingletonMethod("rmdir", callbackFactory.getSingletonMethod("rmdir", RubyString.class));
        dirClass.defineSingletonMethod("unlink", callbackFactory.getSingletonMethod("rmdir", RubyString.class));
        dirClass.defineSingletonMethod("delete", callbackFactory.getSingletonMethod("rmdir", RubyString.class));
        dirClass.defineMethod("close", callbackFactory.getMethod("close"));
        dirClass.defineMethod("each", callbackFactory.getMethod("each"));
        dirClass.defineMethod("entries", callbackFactory.getMethod("entries"));
        dirClass.defineMethod("path", callbackFactory.getMethod("path"));
        dirClass.defineMethod("tell", callbackFactory.getMethod("tell"));
        dirClass.defineAlias("pos", "tell");
        dirClass.defineMethod("seek", callbackFactory.getMethod("seek", RubyFixnum.class));
        dirClass.defineMethod("pos=", callbackFactory.getMethod("setPos", RubyFixnum.class));
        dirClass.defineMethod("read", callbackFactory.getMethod("read"));
        dirClass.defineMethod("rewind", callbackFactory.getMethod("rewind"));
        dirClass.defineMethod("initialize", callbackFactory.getMethod("initialize", RubyString.class));
        return dirClass;
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyDir result = new RubyDir(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public IRubyObject initialize(RubyString newPath) {
        newPath.checkSafeString();
        this.dir = JRubyFile.create(this.getRuntime().getCurrentDirectory(), newPath.toString());
        if (!this.dir.isDirectory()) {
            this.dir = null;
            throw this.getRuntime().newErrnoENOENTError(newPath.toString() + " is not a directory");
        }
        this.path = newPath;
        ArrayList<String> snapshotList = new ArrayList<String>();
        snapshotList.add(".");
        snapshotList.add("..");
        snapshotList.addAll(RubyDir.getContents(this.dir));
        this.snapshot = snapshotList.toArray(new String[snapshotList.size()]);
        this.pos = 0;
        return this;
    }

    public static IRubyObject glob(IRubyObject recv, RubyString pat) {
        String pattern = pat.toString();
        Object[] files = new Glob(recv.getRuntime().getCurrentDirectory(), pattern).getNames();
        ThreadContext context = recv.getRuntime().getCurrentContext();
        if (context.isBlockGiven()) {
            for (int i = 0; i < files.length; ++i) {
                context.yield(JavaUtil.convertJavaToRuby(recv.getRuntime(), files[i]));
            }
            return recv.getRuntime().getNil();
        }
        return recv.getRuntime().newArray(JavaUtil.convertJavaArrayToRuby(recv.getRuntime(), files));
    }

    public RubyArray entries() {
        return this.getRuntime().newArray(JavaUtil.convertJavaArrayToRuby(this.getRuntime(), this.snapshot));
    }

    public static RubyArray entries(IRubyObject recv, RubyString path) {
        JRubyFile directory = JRubyFile.create(recv.getRuntime().getCurrentDirectory(), path.toString());
        if (!directory.isDirectory()) {
            throw recv.getRuntime().newErrnoENOENTError("No such directory");
        }
        List fileList = RubyDir.getContents(directory);
        fileList.add(0, ".");
        fileList.add(1, "..");
        Object[] files = fileList.toArray();
        return recv.getRuntime().newArray(JavaUtil.convertJavaArrayToRuby(recv.getRuntime(), files));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject chdir(IRubyObject recv, IRubyObject[] args) {
        recv.checkArgumentCount(args, 0, 1);
        RubyString path = args.length == 1 ? args[0].convertToString() : RubyDir.getHomeDirectoryPath(recv);
        JRubyFile dir = RubyDir.getDir(recv.getRuntime(), path.toString(), true);
        String realPath = null;
        String oldCwd = recv.getRuntime().getCurrentDirectory();
        try {
            realPath = dir.getCanonicalPath();
        }
        catch (IOException e) {
            realPath = dir.getAbsolutePath();
        }
        IRubyObject result = null;
        ThreadContext tc = recv.getRuntime().getCurrentContext();
        if (tc.isBlockGiven()) {
            recv.getRuntime().setCurrentDirectory(realPath);
            try {
                result = tc.yield(path);
            }
            finally {
                recv.getRuntime().setCurrentDirectory(oldCwd);
            }
        } else {
            recv.getRuntime().setCurrentDirectory(realPath);
            result = recv.getRuntime().newFixnum(0L);
        }
        return result;
    }

    public static IRubyObject chroot(IRubyObject recv, RubyString path) {
        throw recv.getRuntime().newNotImplementedError("chroot not implemented: chroot is non-portable and is not supported.");
    }

    public static IRubyObject rmdir(IRubyObject recv, RubyString path) {
        JRubyFile directory = RubyDir.getDir(recv.getRuntime(), path.toString(), true);
        if (!directory.delete()) {
            throw recv.getRuntime().newSystemCallError("No such directory");
        }
        return recv.getRuntime().newFixnum(0L);
    }

    public static IRubyObject foreach(IRubyObject recv, RubyString path) {
        path.checkSafeString();
        RubyDir dir = (RubyDir)RubyDir.newInstance(recv.getRuntime().getClass("Dir"), new IRubyObject[]{path});
        dir.each();
        return recv.getRuntime().getNil();
    }

    public static RubyString getwd(IRubyObject recv) {
        return recv.getRuntime().newString(recv.getRuntime().getCurrentDirectory());
    }

    public static IRubyObject mkdir(IRubyObject recv, IRubyObject[] args) {
        if (args.length < 1) {
            throw recv.getRuntime().newArgumentError(args.length, 1);
        }
        if (args.length > 2) {
            throw recv.getRuntime().newArgumentError(args.length, 2);
        }
        args[0].checkSafeString();
        String path = args[0].toString();
        File newDir = RubyDir.getDir(recv.getRuntime(), path, false);
        if (File.separatorChar == '\\') {
            newDir = new File(((File)newDir).getPath());
        }
        return newDir.mkdirs() ? RubyFixnum.zero(recv.getRuntime()) : RubyFixnum.one(recv.getRuntime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject open(IRubyObject recv, RubyString path) {
        RubyDir directory = (RubyDir)RubyDir.newInstance(recv.getRuntime().getClass("Dir"), new IRubyObject[]{path});
        ThreadContext tc = recv.getRuntime().getCurrentContext();
        if (tc.isBlockGiven()) {
            try {
                tc.yield(directory);
            }
            finally {
                directory.close();
            }
            return recv.getRuntime().getNil();
        }
        return directory;
    }

    public IRubyObject close() {
        this.isOpen = false;
        return this.getRuntime().getNil();
    }

    public IRubyObject each() {
        String[] contents = this.snapshot;
        ThreadContext context = this.getRuntime().getCurrentContext();
        for (int i = 0; i < contents.length; ++i) {
            context.yield(this.getRuntime().newString(contents[i]));
        }
        return this;
    }

    public RubyInteger tell() {
        return this.getRuntime().newFixnum(this.pos);
    }

    public IRubyObject seek(RubyFixnum newPos) {
        this.setPos(newPos);
        return this;
    }

    public IRubyObject setPos(RubyFixnum newPos) {
        this.pos = (int)newPos.getLongValue();
        return newPos;
    }

    public IRubyObject path() {
        if (!this.isOpen) {
            throw this.getRuntime().newIOError("closed directory");
        }
        return this.path;
    }

    public IRubyObject read() {
        if (!this.isOpen) {
            throw this.getRuntime().newIOError("Directory already closed");
        }
        if (this.pos >= this.snapshot.length) {
            return this.getRuntime().getNil();
        }
        RubyString result = this.getRuntime().newString(this.snapshot[this.pos]);
        ++this.pos;
        return result;
    }

    public IRubyObject rewind() {
        this.pos = 0;
        return this.getRuntime().newFixnum(this.pos);
    }

    protected static JRubyFile getDir(IRuby runtime, String path, boolean mustExist) {
        JRubyFile result = JRubyFile.create(runtime.getCurrentDirectory(), path);
        boolean isDirectory = result.isDirectory();
        if (mustExist && !isDirectory) {
            throw runtime.newErrnoENOENTError(path + " is not a directory");
        }
        if (!mustExist && isDirectory) {
            throw runtime.newErrnoEEXISTError("File exists - " + path);
        }
        return result;
    }

    protected static List getContents(File directory) {
        String[] contents = directory.list();
        ArrayList<String> result = new ArrayList<String>();
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                result.add(contents[i]);
            }
        }
        return result;
    }

    protected static List getContents(File directory, IRuby runtime) {
        ArrayList<RubyString> result = new ArrayList<RubyString>();
        String[] contents = directory.list();
        for (int i = 0; i < contents.length; ++i) {
            result.add(runtime.newString(contents[i]));
        }
        return result;
    }

    public static IRubyObject getHomeDirectoryPath(IRubyObject recv, String user) {
        return recv.getRuntime().evalScript("File.open('/etc/passwd') do |f| f.readlines.each do|l| f = l.split(':'); return f[5] if f[0] == '" + user + "'; end; end; nil");
    }

    public static RubyString getHomeDirectoryPath(IRubyObject recv) {
        RubyHash hash = (RubyHash)recv.getRuntime().getObject().getConstant("ENV_JAVA");
        IRubyObject home = hash.aref(recv.getRuntime().newString("user.home"));
        if (home == null || home.isNil()) {
            home = hash.aref(recv.getRuntime().newString("LOGDIR"));
        }
        if (home == null || home.isNil()) {
            throw recv.getRuntime().newArgumentError("user.home/LOGDIR not set");
        }
        return (RubyString)home;
    }
}

