/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.UnmappableCharacterException;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyIconv
extends RubyObject {
    public RubyIconv(IRuby runtime, RubyClass type) {
        super(runtime, type);
    }

    public static void createIconv(IRuby runtime) {
        RubyClass iconvClass = runtime.defineClass("Iconv", runtime.getObject());
        iconvClass.defineClassUnder("IllegalEncoding", runtime.getClass("ArgumentError"));
        iconvClass.defineClassUnder("IllegalSequence", runtime.getClass("ArgumentError"));
        iconvClass.defineClassUnder("InvalidCharacter", runtime.getClass("ArgumentError"));
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyIconv.class);
        iconvClass.defineSingletonMethod("new", callbackFactory.getOptSingletonMethod("newInstance"));
        iconvClass.defineSingletonMethod("iconv", callbackFactory.getOptSingletonMethod("iconv"));
        iconvClass.defineSingletonMethod("conv", callbackFactory.getOptSingletonMethod("conv"));
        iconvClass.defineMethod("initialize", callbackFactory.getOptMethod("initialize"));
    }

    @Override
    public IRubyObject initialize(IRubyObject[] args) {
        this.checkArgumentCount(args, 2, 2);
        return this;
    }

    public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
        RubyIconv result = new RubyIconv(recv.getRuntime(), (RubyClass)recv);
        result.callInit(args);
        return result;
    }

    public static IRubyObject iconv(IRubyObject recv, IRubyObject[] args) {
        return RubyIconv.convertWithArgs(recv, args, "iconv");
    }

    public static IRubyObject conv(IRubyObject recv, IRubyObject[] args) {
        return RubyIconv.convertWithArgs(recv, args, "conv").join(recv.getRuntime().newString(""));
    }

    public static RubyArray convertWithArgs(IRubyObject recv, IRubyObject[] args, String function) {
        recv.checkArgumentCount(args, 3, -1);
        String fromEncoding = args[1].convertToString().toString();
        String toEncoding = args[0].convertToString().toString();
        RubyArray array = recv.getRuntime().newArray();
        for (int i = 2; i < args.length; ++i) {
            array.append(RubyIconv.convert2(fromEncoding, toEncoding, args[i].convertToString()));
        }
        return array;
    }

    private static IRubyObject convert2(String fromEncoding, String toEncoding, RubyString original) {
        try {
            byte[] bytes = original.toString().getBytes("ISO8859-1");
            ByteBuffer buf = ByteBuffer.wrap(bytes);
            CharsetDecoder decoder = Charset.forName(fromEncoding).newDecoder();
            decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            CharBuffer cbuf = decoder.decode(buf);
            CharsetEncoder encoder = Charset.forName(toEncoding).newEncoder();
            encoder.onUnmappableCharacter(CodingErrorAction.REPORT);
            buf = encoder.encode(cbuf);
            byte[] arr = buf.array();
            bytes = new byte[buf.limit()];
            System.arraycopy(arr, 0, bytes, 0, bytes.length);
            return original.getRuntime().newString(new String(bytes, "ISO8859-1"));
        }
        catch (UnmappableCharacterException e) {
        }
        catch (CharacterCodingException e) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return original.getRuntime().getNil();
    }
}

