/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class RubyInteger
extends RubyNumeric {
    public RubyInteger(IRuby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    @Override
    public RubyInteger convertToInteger() {
        return this;
    }

    protected RubyFloat toFloat() {
        return RubyFloat.newFloat(this.getRuntime(), this.getDoubleValue());
    }

    public RubyString chr() {
        if (this.getLongValue() < 0L || this.getLongValue() > 255L) {
            throw this.getRuntime().newRangeError(this.toString() + " out of char range");
        }
        return this.getRuntime().newString(new String(new char[]{(char)this.getLongValue()}));
    }

    public IRubyObject downto(IRubyObject to) {
        RubyNumeric i = this;
        ThreadContext context = this.getRuntime().getCurrentContext();
        while (!i.callMethod(context, "<", to).isTrue()) {
            context.yield(i);
            i = (RubyNumeric)i.callMethod(context, "-", RubyFixnum.one(this.getRuntime()));
        }
        return this;
    }

    @Override
    public RubyBoolean int_p() {
        return this.getRuntime().getTrue();
    }

    public IRubyObject step(IRubyObject to, IRubyObject step) {
        RubyNumeric test = (RubyNumeric)to;
        RubyNumeric i = this;
        if (((RubyNumeric)step).getLongValue() == 0L) {
            throw this.getRuntime().newArgumentError("step cannot be 0");
        }
        String cmp = "<";
        if (((RubyBoolean)step.callMethod(this.getRuntime().getCurrentContext(), "<", this.getRuntime().newFixnum(0L))).isFalse()) {
            cmp = ">";
        }
        ThreadContext context = this.getRuntime().getCurrentContext();
        while (!i.callMethod(context, cmp, test).isTrue()) {
            context.yield(i);
            i = (RubyNumeric)i.callMethod(context, "+", step);
        }
        return this;
    }

    public IRubyObject times() {
        RubyNumeric i = RubyFixnum.zero(this.getRuntime());
        ThreadContext context = this.getRuntime().getCurrentContext();
        while (i.callMethod(context, "<", this).isTrue()) {
            context.yield(i);
            i = (RubyNumeric)i.callMethod(context, "+", RubyFixnum.one(this.getRuntime()));
        }
        return this;
    }

    public IRubyObject next() {
        return this.callMethod(this.getRuntime().getCurrentContext(), "+", RubyFixnum.one(this.getRuntime()));
    }

    public IRubyObject upto(IRubyObject to) {
        RubyNumeric test = (RubyNumeric)to;
        RubyNumeric i = this;
        ThreadContext context = this.getRuntime().getCurrentContext();
        while (!i.callMethod(context, ">", test).isTrue()) {
            context.yield(i);
            i = (RubyNumeric)i.callMethod(context, "+", RubyFixnum.one(this.getRuntime()));
        }
        return this;
    }

    public RubyInteger to_i() {
        return this;
    }

    @Override
    public RubyNumeric multiplyWith(RubyBignum value) {
        return value.multiplyWith(this);
    }
}

