/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyKernel;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyUnboundMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.methods.IterateCallable;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyMethod
extends RubyObject {
    protected RubyModule implementationModule;
    protected String methodName;
    protected RubyModule originModule;
    protected String originName;
    protected ICallable method;
    protected IRubyObject receiver;

    protected RubyMethod(IRuby runtime, RubyClass rubyClass) {
        super(runtime, rubyClass);
    }

    public static RubyClass createMethodClass(IRuby runtime) {
        RubyClass methodClass = runtime.defineClass("Method", runtime.getObject());
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyMethod.class);
        methodClass.defineMethod("arity", callbackFactory.getMethod("arity"));
        methodClass.defineMethod("to_proc", callbackFactory.getMethod("to_proc"));
        methodClass.defineMethod("unbind", callbackFactory.getMethod("unbind"));
        methodClass.defineMethod("call", callbackFactory.getOptMethod("call"));
        methodClass.defineMethod("[]", callbackFactory.getOptMethod("call"));
        return methodClass;
    }

    public static RubyMethod newMethod(RubyModule implementationModule, String methodName, RubyModule originModule, String originName, ICallable method, IRubyObject receiver) {
        IRuby runtime = implementationModule.getRuntime();
        RubyMethod newMethod = new RubyMethod(runtime, runtime.getClass("Method"));
        newMethod.implementationModule = implementationModule;
        newMethod.methodName = methodName;
        newMethod.originModule = originModule;
        newMethod.originName = originName;
        newMethod.method = method;
        newMethod.receiver = receiver;
        return newMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject call(IRubyObject[] args) {
        assert (args != null);
        ThreadContext tc = this.getRuntime().getCurrentContext();
        this.method.getArity().checkArity(this.getRuntime(), args);
        tc.setIfBlockAvailable();
        try {
            IRubyObject iRubyObject = this.method.call(tc, this.receiver, this.implementationModule, this.methodName, args, false);
            return iRubyObject;
        }
        finally {
            tc.clearIfBlockAvailable();
        }
    }

    public RubyFixnum arity() {
        return this.getRuntime().newFixnum(this.method.getArity().getValue());
    }

    public IRubyObject to_proc() {
        CallbackFactory f = this.getRuntime().callbackFactory(RubyMethod.class);
        IRuby r = this.getRuntime();
        ThreadContext tc = r.getCurrentContext();
        tc.preToProc(Block.createBlock(null, tc.getCurrentScope().cloneScope(), new IterateCallable(f.getBlockMethod("bmcall"), this), r.getTopSelf()));
        while (true) {
            try {
                IRubyObject iRubyObject = f.getSingletonMethod("mproc").execute(this.getRuntime().getNil(), IRubyObject.NULL_ARRAY);
                return iRubyObject;
            }
            catch (JumpException je) {
                if (je.getJumpType() == JumpException.JumpType.BreakJump) {
                    IRubyObject breakValue = (IRubyObject)je.getPrimaryData();
                    IRubyObject iRubyObject = breakValue == null ? r.getNil() : breakValue;
                    return iRubyObject;
                }
                if (je.getJumpType() != JumpException.JumpType.ReturnJump) continue;
                IRubyObject iRubyObject = (IRubyObject)je.getPrimaryData();
                return iRubyObject;
                if (je.getJumpType() == JumpException.JumpType.RetryJump) continue;
                throw je;
            }
            break;
        }
        finally {
            tc.postToProc();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject mproc(IRubyObject recv) {
        IRuby runtime = recv.getRuntime();
        ThreadContext tc = runtime.getCurrentContext();
        tc.preMproc();
        try {
            RubyProc rubyProc = RubyKernel.proc(recv);
            return rubyProc;
        }
        finally {
            tc.postMproc();
        }
    }

    public static IRubyObject bmcall(IRubyObject blockArg, IRubyObject arg1, IRubyObject self) {
        if (blockArg instanceof RubyArray) {
            return ((RubyMethod)arg1).call(((RubyArray)blockArg).toJavaArray());
        }
        return ((RubyMethod)arg1).call(new IRubyObject[]{blockArg});
    }

    public RubyUnboundMethod unbind() {
        RubyUnboundMethod unboundMethod = RubyUnboundMethod.newUnboundMethod(this.implementationModule, this.methodName, this.originModule, this.originName, this.method);
        unboundMethod.receiver = this;
        unboundMethod.infectBy(this);
        return unboundMethod;
    }
}

