/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyNil
extends RubyObject {
    private final IRuby runtime;

    public RubyNil(IRuby runtime) {
        super(runtime, null);
        this.runtime = runtime;
    }

    @Override
    public IRuby getRuntime() {
        return this.runtime;
    }

    public static RubyClass createNilClass(IRuby runtime) {
        RubyClass nilClass = runtime.defineClass("NilClass", runtime.getObject());
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyNil.class);
        nilClass.defineMethod("type", callbackFactory.getSingletonMethod("type"));
        nilClass.defineMethod("to_i", callbackFactory.getSingletonMethod("to_i"));
        nilClass.defineMethod("to_s", callbackFactory.getSingletonMethod("to_s"));
        nilClass.defineMethod("to_a", callbackFactory.getSingletonMethod("to_a"));
        nilClass.defineMethod("to_f", callbackFactory.getSingletonMethod("to_f"));
        nilClass.defineMethod("inspect", callbackFactory.getSingletonMethod("inspect"));
        nilClass.defineMethod("&", callbackFactory.getSingletonMethod("op_and", IRubyObject.class));
        nilClass.defineMethod("|", callbackFactory.getSingletonMethod("op_or", IRubyObject.class));
        nilClass.defineMethod("^", callbackFactory.getSingletonMethod("op_xor", IRubyObject.class));
        nilClass.defineMethod("nil?", callbackFactory.getMethod("nil_p"));
        nilClass.defineMethod("id", callbackFactory.getSingletonMethod("id"));
        nilClass.defineMethod("taint", callbackFactory.getMethod("taint"));
        nilClass.defineMethod("freeze", callbackFactory.getMethod("freeze"));
        nilClass.getMetaClass().undefineMethod("new");
        runtime.defineGlobalConstant("NIL", runtime.getNil());
        return nilClass;
    }

    @Override
    public RubyClass getMetaClass() {
        return this.runtime.getNilClass();
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    public static RubyFixnum to_i(IRubyObject recv) {
        return RubyFixnum.zero(recv.getRuntime());
    }

    public static RubyFloat to_f(IRubyObject recv) {
        return RubyFloat.newFloat(recv.getRuntime(), 0.0);
    }

    public static RubyString to_s(IRubyObject recv) {
        return recv.getRuntime().newString("");
    }

    public static RubyArray to_a(IRubyObject recv) {
        return recv.getRuntime().newArray(0);
    }

    public static RubyString inspect(IRubyObject recv) {
        return recv.getRuntime().newString("nil");
    }

    public static RubyClass type(IRubyObject recv) {
        return recv.getRuntime().getClass("NilClass");
    }

    public static RubyBoolean op_and(IRubyObject recv, IRubyObject obj) {
        return recv.getRuntime().getFalse();
    }

    public static RubyBoolean op_or(IRubyObject recv, IRubyObject obj) {
        return recv.getRuntime().newBoolean(obj.isTrue());
    }

    public static RubyBoolean op_xor(IRubyObject recv, IRubyObject obj) {
        return recv.getRuntime().newBoolean(obj.isTrue());
    }

    public static RubyFixnum id(IRubyObject recv) {
        return recv.getRuntime().newFixnum(4L);
    }

    @Override
    public boolean isNil() {
        return true;
    }

    @Override
    public boolean isFalse() {
        return true;
    }

    @Override
    public boolean isTrue() {
        return false;
    }

    @Override
    public IRubyObject freeze() {
        return this;
    }

    @Override
    public IRubyObject nil_p() {
        return this.getRuntime().getTrue();
    }

    @Override
    public IRubyObject taint() {
        return this;
    }

    @Override
    public RubyFixnum id() {
        return this.getRuntime().newFixnum(4L);
    }
}

