/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Iterator;
import org.jruby.IRuby;
import org.jruby.RubyFixnum;
import org.jruby.RubyGC;
import org.jruby.RubyModule;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyObjectSpace {
    public static RubyModule createObjectSpaceModule(IRuby runtime) {
        RubyModule objectSpaceModule = runtime.defineModule("ObjectSpace");
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyObjectSpace.class);
        objectSpaceModule.defineModuleFunction("each_object", callbackFactory.getOptSingletonMethod("each_object"));
        objectSpaceModule.defineModuleFunction("garbage_collect", callbackFactory.getSingletonMethod("garbage_collect"));
        objectSpaceModule.defineModuleFunction("_id2ref", callbackFactory.getSingletonMethod("id2ref", RubyFixnum.class));
        objectSpaceModule.defineModuleFunction("define_finalizer", callbackFactory.getOptSingletonMethod("define_finalizer"));
        objectSpaceModule.defineModuleFunction("undefine_finalizer", callbackFactory.getOptSingletonMethod("undefine_finalizer"));
        return objectSpaceModule;
    }

    public static IRubyObject define_finalizer(IRubyObject recv, IRubyObject[] args) {
        recv.getRuntime().getWarnings().warn("JRuby does not currently support defining finalizers");
        return recv;
    }

    public static IRubyObject undefine_finalizer(IRubyObject recv, IRubyObject[] args) {
        recv.getRuntime().getWarnings().warn("JRuby does not currently support defining finalizers");
        return recv;
    }

    public static IRubyObject id2ref(IRubyObject recv, RubyFixnum id) {
        IRuby runtime = id.getRuntime();
        long longId = id.getLongValue();
        if (longId == 0L) {
            return runtime.getFalse();
        }
        if (longId == 2L) {
            return runtime.getTrue();
        }
        if (longId == 4L) {
            return runtime.getNil();
        }
        if (longId % 2L != 0L) {
            return runtime.newFixnum((longId - 1L) / 2L);
        }
        IRubyObject object = runtime.getObjectSpace().id2ref(longId);
        if (object == null) {
            runtime.newRangeError("not an id value");
        }
        return object;
    }

    public static IRubyObject each_object(IRubyObject recv, IRubyObject[] args) {
        RubyModule rubyClass = args.length == 0 ? recv.getRuntime().getObject() : (RubyModule)args[0];
        int count = 0;
        Iterator iter = recv.getRuntime().getObjectSpace().iterator(rubyClass);
        IRubyObject obj = null;
        ThreadContext context = recv.getRuntime().getCurrentContext();
        while ((obj = (IRubyObject)iter.next()) != null) {
            ++count;
            context.yield(obj);
        }
        return recv.getRuntime().newFixnum(count);
    }

    public static IRubyObject garbage_collect(IRubyObject recv) {
        return RubyGC.start(recv);
    }
}

