/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.jruby.RegexpTranslator;
import org.jruby.ast.Node;
import org.jruby.ast.types.ILiteralNode;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.evaluator.Instruction;
import org.jruby.lexer.yacc.ISourcePosition;

public class RegexpNode
extends Node
implements ILiteralNode {
    static final long serialVersionUID = -1566813018564622077L;
    private static final RegexpTranslator translator = new RegexpTranslator();
    private Pattern pattern;
    private final String value;
    private final int options;

    public RegexpNode(ISourcePosition position, String value, int options) {
        super(position, 73);
        this.value = value;
        this.options = options;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitRegexpNode(this);
    }

    public int getOptions() {
        return this.options;
    }

    public String getValue() {
        return this.value;
    }

    public Pattern getPattern() throws PatternSyntaxException {
        if (this.pattern == null) {
            this.pattern = translator.translate(this.value, this.options, 1);
        }
        return this.pattern;
    }

    @Override
    public List childNodes() {
        return EMPTY_LIST;
    }
}

