/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.exceptions;

public class JumpException
extends RuntimeException {
    private static final long serialVersionUID = -228162532535826617L;
    private JumpType jumpType;
    private Object primaryData;
    private Object secondaryData;
    private Object tertiaryData;

    public JumpException(JumpType jumpType) {
        this.jumpType = jumpType;
    }

    public JumpException(String msg, JumpType jumpType) {
        super(msg);
        this.jumpType = jumpType;
    }

    public JumpException(String msg, Throwable cause, JumpType jumpType) {
        super(msg, cause);
        this.jumpType = jumpType;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    protected Throwable originalFillInStackTrace() {
        return super.fillInStackTrace();
    }

    public JumpType getJumpType() {
        return this.jumpType;
    }

    public Object getPrimaryData() {
        return this.primaryData;
    }

    public void setPrimaryData(Object data) {
        this.primaryData = data;
    }

    public Object getSecondaryData() {
        return this.secondaryData;
    }

    public void setSecondaryData(Object secondaryData) {
        this.secondaryData = secondaryData;
    }

    public Object getTertiaryData() {
        return this.tertiaryData;
    }

    public void setTertiaryData(Object tertiaryData) {
        this.tertiaryData = tertiaryData;
    }

    public static final class JumpType {
        public static final int BREAK = 0;
        public static final int NEXT = 1;
        public static final int REDO = 2;
        public static final int RETRY = 3;
        public static final int RETURN = 4;
        public static final int THROW = 5;
        public static final int RAISE = 6;
        public static final JumpType BreakJump = new JumpType(0);
        public static final JumpType NextJump = new JumpType(1);
        public static final JumpType RedoJump = new JumpType(2);
        public static final JumpType RetryJump = new JumpType(3);
        public static final JumpType ReturnJump = new JumpType(4);
        public static final JumpType ThrowJump = new JumpType(5);
        public static final JumpType RaiseJump = new JumpType(6);
        private final int typeId;

        private JumpType(int typeId) {
            this.typeId = typeId;
        }

        public int getTypeId() {
            return this.typeId;
        }
    }
}

