/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.AbstractCallable;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class AbstractMethod
extends AbstractCallable {
    private boolean implIsClass;
    private boolean implIsKernel;

    protected AbstractMethod(RubyModule implementationClass, Visibility visibility) {
        super(implementationClass, visibility);
        if (implementationClass != null) {
            this.implIsClass = implementationClass.isClass();
            this.implIsKernel = implementationClass.equals(implementationClass.getRuntime().getKernel());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject call(ThreadContext context, IRubyObject recv, RubyModule lastClass, String name, IRubyObject[] args, boolean noSuper) {
        this.preMethod(context, lastClass, recv, name, args, noSuper);
        try {
            IRubyObject iRubyObject = this.internalCall(context, recv, lastClass, name, args, noSuper);
            return iRubyObject;
        }
        finally {
            this.postMethod(context);
        }
    }

    @Override
    public boolean isCallableFrom(IRubyObject caller, CallType callType) {
        if (this.getVisibility().isPrivate() && callType == CallType.NORMAL) {
            return false;
        }
        if (this.getVisibility().isProtected()) {
            RubyModule defined = this.getImplementationClass();
            while (defined.isIncluded()) {
                defined = defined.getMetaClass();
            }
            if (!caller.isKindOf(defined)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean needsImplementer() {
        return !this.implIsClass && !this.implIsKernel;
    }
}

