/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import org.jruby.IRuby;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.AbstractMethod;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ICallable;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callback.Callback;

public class CallbackMethod
extends AbstractMethod {
    private Callback callback;

    public CallbackMethod(RubyModule implementationClass, Callback callback, Visibility visibility) {
        super(implementationClass, visibility);
        this.callback = callback;
    }

    @Override
    public void preMethod(ThreadContext context, RubyModule lastClass, IRubyObject recv, String name, IRubyObject[] args, boolean noSuper) {
        context.preReflectedMethodInternalCall(this.implementationClass, lastClass, recv, name, args, noSuper);
    }

    @Override
    public void postMethod(ThreadContext context) {
        context.postReflectedMethodInternalCall();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IRubyObject internalCall(ThreadContext context, IRubyObject receiver, RubyModule lastClass, String name, IRubyObject[] args, boolean noSuper) {
        assert (args != null);
        IRuby runtime = context.getRuntime();
        if (runtime.getTraceFunction() != null) {
            ISourcePosition position = context.getPreviousFramePosition();
            runtime.callTraceFunction(context, "c-call", position, receiver, name, this.getImplementationClass());
            try {
                IRubyObject iRubyObject = this.callback.execute(receiver, args);
                return iRubyObject;
            }
            finally {
                runtime.callTraceFunction(context, "c-return", position, receiver, name, this.getImplementationClass());
            }
        }
        return this.callback.execute(receiver, args);
    }

    public Callback getCallback() {
        return this.callback;
    }

    @Override
    public Arity getArity() {
        return this.getCallback().getArity();
    }

    @Override
    public ICallable dup() {
        return new CallbackMethod(this.getImplementationClass(), this.callback, this.getVisibility());
    }
}

