/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.util.List;
import org.jruby.IRuby;
import org.jruby.Ruby;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaEmbedUtils {
    public static IRuby initialize(List loadPaths) {
        IRuby runtime = Ruby.getDefaultInstance();
        runtime.getLoadService().init(loadPaths);
        runtime.getLoadService().require("java");
        return runtime;
    }

    public static void terminate(IRuby runtime) {
        runtime.tearDown();
        runtime.getThreadService().disposeCurrentThread();
    }

    public static Object invokeMethod(IRuby runtime, Object receiver, String method, Object[] args, Class returnType) {
        IRubyObject rubyReceiver = receiver != null ? JavaUtil.convertJavaToRuby(runtime, receiver) : runtime.getTopSelf();
        IRubyObject[] rubyArgs = JavaUtil.convertJavaArrayToRuby(runtime, args);
        IRubyObject javaUtilities = runtime.getObject().getConstant("JavaUtilities");
        ThreadContext context = runtime.getCurrentContext();
        for (int i = 0; i < rubyArgs.length; ++i) {
            IRubyObject obj = rubyArgs[i];
            if (!(obj instanceof JavaObject)) continue;
            rubyArgs[i] = javaUtilities.callMethod(context, "wrap", obj);
        }
        IRubyObject result = rubyReceiver.callMethod(context, method, rubyArgs);
        return JavaEmbedUtils.rubyToJava(runtime, result, returnType);
    }

    public static Object rubyToJava(IRuby runtime, IRubyObject value, Class type) {
        return JavaUtil.convertArgument(Java.ruby_to_java(runtime.getObject(), value), type);
    }

    public static IRubyObject javaToRuby(IRuby runtime, Object value) {
        if (value instanceof IRubyObject) {
            return (IRubyObject)value;
        }
        IRubyObject result = JavaUtil.convertJavaToRuby(runtime, value);
        if (result instanceof JavaObject) {
            return runtime.getModule("JavaUtilities").callMethod(runtime.getCurrentContext(), "wrap", result);
        }
        return result;
    }
}

