/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import org.jruby.IRuby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyString;
import org.jruby.javasupport.JavaAccessibleObject;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class JavaField
extends JavaAccessibleObject {
    private Field field;

    public static RubyClass createJavaFieldClass(IRuby runtime, RubyModule javaModule) {
        RubyClass result = javaModule.defineClassUnder("JavaField", runtime.getObject());
        CallbackFactory callbackFactory = runtime.callbackFactory(JavaField.class);
        JavaAccessibleObject.registerRubyMethods(runtime, result);
        result.defineMethod("value_type", callbackFactory.getMethod("value_type"));
        result.defineMethod("public?", callbackFactory.getMethod("public_p"));
        result.defineMethod("static?", callbackFactory.getMethod("static_p"));
        result.defineMethod("value", callbackFactory.getMethod("value", IRubyObject.class));
        result.defineMethod("set_value", callbackFactory.getMethod("set_value", IRubyObject.class, IRubyObject.class));
        result.defineMethod("final?", callbackFactory.getMethod("final_p"));
        result.defineMethod("static_value", callbackFactory.getMethod("static_value"));
        result.defineMethod("name", callbackFactory.getMethod("name"));
        result.defineMethod("==", callbackFactory.getMethod("equal", IRubyObject.class));
        result.defineAlias("===", "==");
        return result;
    }

    public JavaField(IRuby runtime, Field field) {
        super(runtime, runtime.getModule("Java").getClass("JavaField"));
        this.field = field;
    }

    public RubyString value_type() {
        return this.getRuntime().newString(this.field.getType().getName());
    }

    @Override
    public IRubyObject equal(IRubyObject other) {
        if (!(other instanceof JavaField)) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().newBoolean(this.field.equals(((JavaField)other).field));
    }

    public RubyBoolean public_p() {
        return this.getRuntime().newBoolean(Modifier.isPublic(this.field.getModifiers()));
    }

    public RubyBoolean static_p() {
        return this.getRuntime().newBoolean(Modifier.isStatic(this.field.getModifiers()));
    }

    public JavaObject value(IRubyObject object) {
        if (!(object instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object");
        }
        Object javaObject = ((JavaObject)object).getValue();
        try {
            return JavaObject.wrap(this.getRuntime(), this.field.get(javaObject));
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access");
        }
    }

    public JavaObject set_value(IRubyObject object, IRubyObject value) {
        if (!(object instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object: " + object);
        }
        if (!(value instanceof JavaObject)) {
            throw this.getRuntime().newTypeError("not a java object:" + value);
        }
        Object javaObject = ((JavaObject)object).getValue();
        try {
            Object convertedValue = JavaUtil.convertArgument(((JavaObject)value).getValue(), this.field.getType());
            this.field.set(javaObject, convertedValue);
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal access on setting variable: " + iae.getMessage());
        }
        catch (IllegalArgumentException iae) {
            throw this.getRuntime().newTypeError("wrong type for " + this.field.getType().getName() + ": " + ((JavaObject)value).getValue().getClass().getName());
        }
        return (JavaObject)value;
    }

    public RubyBoolean final_p() {
        return this.getRuntime().newBoolean(Modifier.isFinal(this.field.getModifiers()));
    }

    public JavaObject static_value() {
        try {
            this.field.setAccessible(true);
            return JavaObject.wrap(this.getRuntime(), this.field.get(null));
        }
        catch (IllegalAccessException iae) {
            throw this.getRuntime().newTypeError("illegal static value access: " + iae.getMessage());
        }
    }

    public RubyString name() {
        return this.getRuntime().newString(this.field.getName());
    }

    @Override
    protected AccessibleObject accesibleObject() {
        return this.field;
    }
}

