/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.runtime.Arity;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.runtime.builtin.meta.ObjectMetaClass;
import org.jruby.util.collections.SinglyLinkedList;

public class ArrayMetaClass
extends ObjectMetaClass {
    public ArrayMetaClass(IRuby runtime) {
        super("Array", RubyArray.class, runtime.getObject());
    }

    public ArrayMetaClass(String name, RubyClass superClass, SinglyLinkedList parentCRef) {
        super(name, RubyArray.class, superClass, parentCRef);
    }

    @Override
    protected AbstractMetaClass.Meta getMeta() {
        return new ArrayMeta();
    }

    @Override
    public RubyClass newSubClass(String name, SinglyLinkedList parentCRef) {
        return new ArrayMetaClass(name, (RubyClass)this, parentCRef);
    }

    @Override
    protected IRubyObject allocateObject() {
        RubyArray instance = this.getRuntime().newArray();
        instance.setMetaClass(this);
        return instance;
    }

    @Override
    public IRubyObject newInstance(IRubyObject[] args) {
        RubyArray instance = (RubyArray)this.allocateObject();
        instance.setMetaClass(this);
        instance.callInit(args);
        return instance;
    }

    public IRubyObject create(IRubyObject[] args) {
        RubyArray array = (RubyArray)this.allocateObject();
        array.setMetaClass(this);
        if (args.length >= 1) {
            for (int i = 0; i < args.length; ++i) {
                array.add(args[i]);
            }
        }
        return array;
    }

    protected class ArrayMeta
    extends AbstractMetaClass.Meta {
        protected ArrayMeta() {
        }

        @Override
        protected void initializeClass() {
            ArrayMetaClass.this.includeModule(ArrayMetaClass.this.getRuntime().getModule("Enumerable"));
            ArrayMetaClass.this.defineMethod("+", Arity.singleArgument(), "op_plus");
            ArrayMetaClass.this.defineMethod("*", Arity.singleArgument(), "op_times");
            ArrayMetaClass.this.defineMethod("-", Arity.singleArgument(), "op_diff");
            ArrayMetaClass.this.defineMethod("&", Arity.singleArgument(), "op_and");
            ArrayMetaClass.this.defineMethod("|", Arity.singleArgument(), "op_or");
            ArrayMetaClass.this.defineMethod("[]", Arity.optional(), "aref");
            ArrayMetaClass.this.defineMethod("[]=", Arity.optional(), "aset");
            ArrayMetaClass.this.defineMethod("<=>", Arity.singleArgument(), "op_cmp");
            ArrayMetaClass.this.defineMethod("<<", Arity.singleArgument(), "append");
            ArrayMetaClass.this.defineMethod("==", Arity.singleArgument(), "array_op_equal");
            ArrayMetaClass.this.defineMethod("assoc", Arity.singleArgument());
            ArrayMetaClass.this.defineMethod("at", Arity.singleArgument(), "at");
            ArrayMetaClass.this.defineMethod("clear", Arity.noArguments(), "rb_clear");
            ArrayMetaClass.this.defineMethod("clone", Arity.noArguments(), "rbClone");
            ArrayMetaClass.this.defineMethod("collect", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("collect!", Arity.noArguments(), "collect_bang");
            ArrayMetaClass.this.defineMethod("compact", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("compact!", Arity.noArguments(), "compact_bang");
            ArrayMetaClass.this.defineMethod("concat", Arity.singleArgument());
            ArrayMetaClass.this.defineMethod("delete", Arity.singleArgument());
            ArrayMetaClass.this.defineMethod("delete_at", Arity.singleArgument());
            ArrayMetaClass.this.defineMethod("delete_if", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("each", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("each_index", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("eql?", Arity.singleArgument(), "eql");
            ArrayMetaClass.this.defineMethod("empty?", Arity.noArguments(), "empty_p");
            ArrayMetaClass.this.defineMethod("fetch", Arity.optional());
            ArrayMetaClass.this.defineMethod("fill", Arity.optional());
            ArrayMetaClass.this.defineMethod("first", Arity.optional());
            ArrayMetaClass.this.defineMethod("flatten", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("flatten!", Arity.noArguments(), "flatten_bang");
            ArrayMetaClass.this.defineMethod("frozen?", Arity.noArguments(), "frozen");
            ArrayMetaClass.this.defineMethod("hash", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("include?", Arity.singleArgument(), "include_p");
            ArrayMetaClass.this.defineMethod("index", Arity.singleArgument());
            ArrayMetaClass.this.defineMethod("indices", Arity.optional());
            ArrayMetaClass.this.defineMethod("initialize", Arity.optional());
            ArrayMetaClass.this.defineMethod("insert", Arity.optional());
            ArrayMetaClass.this.defineMethod("inspect", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("join", Arity.optional());
            ArrayMetaClass.this.defineMethod("last", Arity.optional());
            ArrayMetaClass.this.defineMethod("length", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("nitems", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("pack", Arity.singleArgument());
            ArrayMetaClass.this.defineMethod("pop", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("push", Arity.optional());
            ArrayMetaClass.this.defineMethod("rassoc", Arity.singleArgument());
            ArrayMetaClass.this.defineMethod("reject!", Arity.noArguments(), "reject_bang");
            ArrayMetaClass.this.defineMethod("replace", Arity.singleArgument(), "replace");
            ArrayMetaClass.this.defineMethod("reverse", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("reverse!", Arity.noArguments(), "reverse_bang");
            ArrayMetaClass.this.defineMethod("reverse_each", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("rindex", Arity.singleArgument());
            ArrayMetaClass.this.defineMethod("shift", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("sort", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("sort!", Arity.noArguments(), "sort_bang");
            ArrayMetaClass.this.defineMethod("slice", Arity.optional(), "aref");
            ArrayMetaClass.this.defineMethod("slice!", Arity.optional(), "slice_bang");
            ArrayMetaClass.this.defineMethod("to_a", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("to_ary", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("to_s", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("transpose", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("uniq", Arity.noArguments());
            ArrayMetaClass.this.defineMethod("uniq!", Arity.noArguments(), "uniq_bang");
            ArrayMetaClass.this.defineMethod("unshift", Arity.optional());
            ArrayMetaClass.this.defineMethod("values_at", Arity.optional());
            ArrayMetaClass.this.defineAlias("===", "==");
            ArrayMetaClass.this.defineAlias("size", "length");
            ArrayMetaClass.this.defineAlias("indexes", "indices");
            ArrayMetaClass.this.defineAlias("filter", "collect!");
            ArrayMetaClass.this.defineAlias("map!", "collect!");
            ArrayMetaClass.this.defineSingletonMethod("new", Arity.optional(), "newInstance");
            ArrayMetaClass.this.defineSingletonMethod("[]", Arity.optional(), "create");
        }
    }
}

