/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import java.io.IOException;
import java.nio.channels.Channel;
import java.nio.channels.Pipe;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import org.jruby.IRuby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyIO;
import org.jruby.RubyKernel;
import org.jruby.RubyString;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.runtime.builtin.meta.FileMetaClass;
import org.jruby.runtime.builtin.meta.ObjectMetaClass;
import org.jruby.util.collections.SinglyLinkedList;

public class IOMetaClass
extends ObjectMetaClass {
    public IOMetaClass(IRuby runtime) {
        this("IO", RubyIO.class, runtime.getObject());
    }

    public IOMetaClass(String name, RubyClass superClass, SinglyLinkedList parentCRef) {
        this(name, RubyIO.class, superClass, parentCRef);
    }

    public IOMetaClass(String name, Class clazz, RubyClass superClass) {
        super(name, clazz, superClass);
    }

    public IOMetaClass(String name, Class clazz, RubyClass superClass, SinglyLinkedList parentCRef) {
        super(name, clazz, superClass, parentCRef);
    }

    @Override
    protected AbstractMetaClass.Meta getMeta() {
        return new IOMeta();
    }

    @Override
    public RubyClass newSubClass(String name, SinglyLinkedList parentCRef) {
        return new IOMetaClass(name, (RubyClass)this, parentCRef);
    }

    @Override
    public IRubyObject allocateObject() {
        return new RubyIO(this.getRuntime(), this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject foreach(IRubyObject[] args) {
        int count = this.checkArgumentCount(args, 1, -1);
        RubyString filename = args[0].convertToString();
        filename.checkSafeString();
        RubyIO io = (RubyIO)((FileMetaClass)this.getRuntime().getClass("File")).open(new IRubyObject[]{filename}, false);
        if (!io.isNil() && io.isOpen()) {
            try {
                IRubyObject[] newArgs = new IRubyObject[count - 1];
                System.arraycopy(args, 1, newArgs, 0, count - 1);
                IRubyObject nextLine = io.internalGets(newArgs);
                while (!nextLine.isNil()) {
                    this.getRuntime().getCurrentContext().yield(nextLine);
                    nextLine = io.internalGets(newArgs);
                }
            }
            finally {
                io.close();
            }
        }
        return this.getRuntime().getNil();
    }

    private static void registerSelect(Selector selector, IRubyObject obj, int ops) throws IOException {
        RubyIO ioObj;
        if (!(obj instanceof RubyIO)) {
            if (!obj.respondsTo("to_io")) {
                return;
            }
            ioObj = (RubyIO)obj.callMethod(obj.getRuntime().getCurrentContext(), "to_io");
        } else {
            ioObj = (RubyIO)obj;
        }
        Channel channel = ioObj.getChannel();
        if (channel == null || !(channel instanceof SelectableChannel)) {
            return;
        }
        ((SelectableChannel)channel).configureBlocking(false);
        int real_ops = ((SelectableChannel)channel).validOps() & ops;
        SelectionKey key = ((SelectableChannel)channel).keyFor(selector);
        if (key == null) {
            ((SelectableChannel)channel).register(selector, real_ops, obj);
        } else {
            key.interestOps(key.interestOps() | real_ops);
        }
    }

    public IRubyObject select(IRubyObject[] args) {
        return IOMetaClass.select_static(this.getRuntime(), args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject select_static(IRuby runtime, IRubyObject[] args) {
        try {
            boolean atLeastOneDescriptor = false;
            Selector selector = Selector.open();
            if (!args[0].isNil()) {
                atLeastOneDescriptor = true;
                for (IRubyObject obj : ((RubyArray)args[0]).getList()) {
                    IOMetaClass.registerSelect(selector, obj, 17);
                }
            }
            if (args.length > 1 && !args[1].isNil()) {
                atLeastOneDescriptor = true;
                for (IRubyObject obj : ((RubyArray)args[0]).getList()) {
                    IOMetaClass.registerSelect(selector, obj, 4);
                }
            }
            if (args.length > 2 && !args[2].isNil()) {
                atLeastOneDescriptor = true;
            }
            long timeout = 0L;
            if (args.length > 3 && !args[3].isNil() && (timeout = args[3] instanceof RubyFloat ? Math.round(((RubyFloat)args[3]).getDoubleValue() * 1000.0) : Math.round(((RubyFixnum)args[3]).getDoubleValue() * 1000.0)) < 0L) {
                throw runtime.newArgumentError("negative timeout given");
            }
            if (!atLeastOneDescriptor) {
                return runtime.getNil();
            }
            if (args.length > 3) {
                selector.select(timeout);
            } else {
                selector.select();
            }
            ArrayList<Object> r = new ArrayList<Object>();
            ArrayList<Object> w = new ArrayList<Object>();
            ArrayList e = new ArrayList();
            for (SelectionKey key : selector.selectedKeys()) {
                if ((key.interestOps() & key.readyOps() & 0x19) != 0) {
                    r.add(key.attachment());
                }
                if ((key.interestOps() & key.readyOps() & 4) == 0) continue;
                w.add(key.attachment());
            }
            for (SelectionKey key : selector.keys()) {
                SelectableChannel channel = key.channel();
                Object object = channel.blockingLock();
                synchronized (object) {
                    boolean blocking = ((RubyIO)key.attachment()).getBlocking();
                    key.cancel();
                    channel.configureBlocking(blocking);
                }
            }
            selector.close();
            if (r.size() == 0 && w.size() == 0 && e.size() == 0) {
                return runtime.getNil();
            }
            ArrayList<RubyArray> ret = new ArrayList<RubyArray>();
            ret.add(RubyArray.newArray(runtime, r));
            ret.add(RubyArray.newArray(runtime, w));
            ret.add(RubyArray.newArray(runtime, e));
            return RubyArray.newArray(runtime, ret);
        }
        catch (IOException e) {
            throw runtime.newIOError(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IRubyObject read(IRubyObject[] args) {
        this.checkArgumentCount(args, 1, 3);
        IRubyObject[] fileArguments = new IRubyObject[]{args[0]};
        RubyIO file = (RubyIO)RubyKernel.open(this, fileArguments);
        IRubyObject[] readArguments = args.length >= 2 ? new IRubyObject[]{args[1].convertToType("Fixnum", "to_int", true)} : new IRubyObject[]{};
        try {
            if (args.length == 3) {
                file.seek(new IRubyObject[]{args[2].convertToType("Fixnum", "to_int", true)});
            }
            IRubyObject iRubyObject = file.read(readArguments);
            return iRubyObject;
        }
        finally {
            file.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RubyArray readlines(IRubyObject[] args) {
        IRubyObject[] iRubyObjectArray;
        int count = this.checkArgumentCount(args, 1, 2);
        IRubyObject[] fileArguments = new IRubyObject[]{args[0]};
        if (count >= 2) {
            IRubyObject[] iRubyObjectArray2 = new IRubyObject[1];
            iRubyObjectArray = iRubyObjectArray2;
            iRubyObjectArray2[0] = args[1];
        } else {
            iRubyObjectArray = IRubyObject.NULL_ARRAY;
        }
        IRubyObject[] separatorArguments = iRubyObjectArray;
        RubyIO file = (RubyIO)RubyKernel.open(this, fileArguments);
        try {
            RubyArray rubyArray = file.readlines(separatorArguments);
            return rubyArray;
        }
        finally {
            file.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public IRubyObject popen(IRubyObject[] args) {
        IRubyObject iRubyObject;
        Process process;
        IRuby runtime = this.getRuntime();
        this.checkArgumentCount(args, 1, 2);
        RubyString cmdObj = args[0].convertToString();
        cmdObj.checkSafeString();
        String command = ((Object)cmdObj).toString();
        ThreadContext tc = runtime.getCurrentContext();
        String shell = System.getProperty("jruby.shell");
        if (shell != null) {
            String shellSwitch = "-c";
            if (!shell.endsWith("sh")) {
                shellSwitch = "/c";
            }
            process = Runtime.getRuntime().exec(new String[]{shell, shellSwitch, command});
        } else {
            process = Runtime.getRuntime().exec(command);
        }
        RubyIO io = new RubyIO(runtime, process);
        if (!tc.isBlockGiven()) return io;
        try {
            tc.yield(io);
            iRubyObject = runtime.getNil();
            io.close();
        }
        catch (Throwable throwable) {
            try {
                io.close();
                runtime.getGlobalVariables().set("$?", runtime.newFixnum(process.waitFor() * 256));
                throw throwable;
            }
            catch (IOException e) {
                throw runtime.newIOErrorFromException(e);
            }
            catch (InterruptedException e) {
                throw runtime.newThreadError("unexpected interrupt");
            }
        }
        runtime.getGlobalVariables().set("$?", runtime.newFixnum(process.waitFor() * 256));
        return iRubyObject;
    }

    public IRubyObject pipe() throws Exception {
        IRuby runtime = this.getRuntime();
        Pipe pipe = Pipe.open();
        return runtime.newArray(new IRubyObject[]{new RubyIO(runtime, pipe.source()), new RubyIO(runtime, pipe.sink())});
    }

    protected class IOMeta
    extends AbstractMetaClass.Meta {
        protected IOMeta() {
        }

        @Override
        protected void initializeClass() {
            IOMetaClass.this.includeModule(IOMetaClass.this.getRuntime().getModule("Enumerable"));
            IOMetaClass.this.defineSingletonMethod("foreach", Arity.optional());
            IOMetaClass.this.defineSingletonMethod("read", Arity.optional());
            IOMetaClass.this.defineSingletonMethod("readlines", Arity.optional());
            IOMetaClass.this.defineSingletonMethod("popen", Arity.optional());
            IOMetaClass.this.defineSingletonMethod("select", Arity.optional());
            IOMetaClass.this.defineSingletonMethod("pipe", Arity.noArguments());
            IOMetaClass.this.defineMethod("<<", Arity.singleArgument(), "addString");
            IOMetaClass.this.defineMethod("binmode", Arity.noArguments());
            IOMetaClass.this.defineMethod("clone", Arity.noArguments(), "clone_IO");
            IOMetaClass.this.defineMethod("close", Arity.noArguments());
            IOMetaClass.this.defineMethod("closed?", Arity.noArguments(), "closed");
            IOMetaClass.this.defineMethod("each", Arity.optional(), "each_line");
            IOMetaClass.this.defineMethod("each_byte", Arity.noArguments());
            IOMetaClass.this.defineMethod("each_line", Arity.optional());
            IOMetaClass.this.defineMethod("eof", Arity.noArguments());
            IOMetaClass.this.defineAlias("eof?", "eof");
            IOMetaClass.this.defineMethod("fcntl", Arity.twoArguments());
            IOMetaClass.this.defineMethod("fileno", Arity.noArguments());
            IOMetaClass.this.defineMethod("flush", Arity.noArguments());
            IOMetaClass.this.defineMethod("fsync", Arity.noArguments());
            IOMetaClass.this.defineMethod("getc", Arity.noArguments());
            IOMetaClass.this.defineMethod("gets", Arity.optional());
            IOMetaClass.this.defineMethod("initialize", Arity.optional());
            IOMetaClass.this.defineMethod("lineno", Arity.noArguments());
            IOMetaClass.this.defineMethod("lineno=", Arity.singleArgument(), "lineno_set");
            IOMetaClass.this.defineMethod("pid", Arity.noArguments());
            IOMetaClass.this.defineMethod("pos", Arity.noArguments());
            IOMetaClass.this.defineMethod("pos=", Arity.singleArgument(), "pos_set");
            IOMetaClass.this.defineMethod("print", Arity.optional());
            IOMetaClass.this.defineMethod("printf", Arity.optional());
            IOMetaClass.this.defineMethod("putc", Arity.singleArgument());
            IOMetaClass.this.defineMethod("puts", Arity.optional());
            IOMetaClass.this.defineMethod("readpartial", Arity.optional());
            IOMetaClass.this.defineMethod("read", Arity.optional());
            IOMetaClass.this.defineMethod("readchar", Arity.noArguments());
            IOMetaClass.this.defineMethod("readline", Arity.optional());
            IOMetaClass.this.defineMethod("readlines", Arity.optional());
            IOMetaClass.this.defineMethod("reopen", Arity.optional());
            IOMetaClass.this.defineMethod("rewind", Arity.noArguments());
            IOMetaClass.this.defineMethod("seek", Arity.optional());
            IOMetaClass.this.defineMethod("sync", Arity.noArguments());
            IOMetaClass.this.defineMethod("sync=", Arity.singleArgument(), "sync_set");
            IOMetaClass.this.defineMethod("sysread", Arity.singleArgument());
            IOMetaClass.this.defineMethod("syswrite", Arity.singleArgument());
            IOMetaClass.this.defineAlias("tell", "pos");
            IOMetaClass.this.defineAlias("to_i", "fileno");
            IOMetaClass.this.defineMethod("to_io", Arity.noArguments());
            IOMetaClass.this.defineMethod("ungetc", Arity.singleArgument());
            IOMetaClass.this.defineMethod("write", Arity.singleArgument());
            IOMetaClass.this.defineMethod("tty?", Arity.noArguments(), "tty");
            IOMetaClass.this.defineAlias("isatty", "tty?");
            IOMetaClass.this.setConstant("SEEK_SET", IOMetaClass.this.getRuntime().newFixnum(0L));
            IOMetaClass.this.setConstant("SEEK_CUR", IOMetaClass.this.getRuntime().newFixnum(1L));
            IOMetaClass.this.setConstant("SEEK_END", IOMetaClass.this.getRuntime().newFixnum(2L));
        }
    }
}

