/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.builtin.meta;

import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyFloat;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.meta.AbstractMetaClass;
import org.jruby.runtime.builtin.meta.NumericMetaClass;
import org.jruby.runtime.builtin.meta.ObjectMetaClass;
import org.jruby.util.collections.SinglyLinkedList;

public class TimeMetaClass
extends ObjectMetaClass {
    private static final String[] months = new String[]{"jan", "feb", "mar", "apr", "may", "jun", "jul", "aug", "sep", "oct", "nov", "dec"};
    private static final long[] time_min = new long[]{1L, 0L, 0L, 0L, 0L};
    private static final long[] time_max = new long[]{31L, 23L, 59L, 60L, Long.MAX_VALUE};

    public TimeMetaClass(IRuby runtime) {
        super("Time", RubyTime.class, runtime.getObject());
    }

    public TimeMetaClass(String name, RubyClass superClass, SinglyLinkedList parentCRef) {
        super(name, RubyTime.class, superClass, parentCRef);
    }

    public TimeMetaClass(String name, Class clazz, RubyClass superClass) {
        super(name, clazz, superClass);
    }

    public TimeMetaClass(String name, Class clazz, RubyClass superClass, SinglyLinkedList parentCRef) {
        super(name, clazz, superClass, parentCRef);
    }

    @Override
    protected AbstractMetaClass.Meta getMeta() {
        return new TimeMeta();
    }

    @Override
    public RubyClass newSubClass(String name, SinglyLinkedList parentCRef) {
        return new NumericMetaClass(name, (RubyClass)this, parentCRef);
    }

    @Override
    protected IRubyObject allocateObject() {
        RubyTime instance = new RubyTime(this.getRuntime(), this);
        instance.setMetaClass(this);
        return instance;
    }

    public IRubyObject s_new() {
        RubyTime time = new RubyTime(this.getRuntime(), this);
        GregorianCalendar cal = new GregorianCalendar();
        cal.setTime(new Date());
        time.setJavaCalendar(cal);
        return time;
    }

    public IRubyObject new_at(IRubyObject[] args) {
        int len = this.checkArgumentCount(args, 1, 2);
        Calendar cal = Calendar.getInstance();
        RubyTime time = new RubyTime(this.getRuntime(), (RubyClass)this, cal);
        if (args[0] instanceof RubyTime) {
            ((RubyTime)args[0]).updateCal(cal);
        } else {
            long seconds = RubyNumeric.num2long(args[0]);
            long millisecs = 0L;
            long microsecs = 0L;
            if (len > 1) {
                long tmp = RubyNumeric.num2long(args[1]);
                millisecs = tmp / 1000L;
                microsecs = tmp % 1000L;
            } else if (args[0] instanceof RubyFloat) {
                double dbl = ((RubyFloat)args[0]).getDoubleValue();
                long micro = (long)((dbl - (double)seconds) * 1000000.0);
                millisecs = micro / 1000L;
                microsecs = micro % 1000L;
            }
            time.setUSec(microsecs);
            cal.setTimeInMillis(seconds * 1000L + millisecs);
        }
        time.callInit(args);
        return time;
    }

    public RubyTime new_local(IRubyObject[] args) {
        return this.createTime(args, false);
    }

    public RubyTime new_utc(IRubyObject[] args) {
        return this.createTime(args, true);
    }

    public RubyTime s_load(IRubyObject from) {
        return this.s_mload((RubyTime)this.s_new(), from);
    }

    protected RubyTime s_mload(RubyTime time, IRubyObject from) {
        int i;
        Calendar calendar = Calendar.getInstance();
        calendar.clear();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        byte[] fromAsBytes = null;
        try {
            fromAsBytes = from.toString().getBytes("ISO8859_1");
        }
        catch (UnsupportedEncodingException uee) {
            throw this.getRuntime().newTypeError("marshaled time format differ");
        }
        if (fromAsBytes.length != 8) {
            throw this.getRuntime().newTypeError("marshaled time format differ");
        }
        int p = 0;
        int s = 0;
        for (i = 0; i < 4; ++i) {
            p |= (fromAsBytes[i] & 0xFF) << 8 * i;
        }
        for (i = 4; i < 8; ++i) {
            s |= (fromAsBytes[i] & 0xFF) << 8 * (i - 4);
        }
        if ((p & Integer.MIN_VALUE) == 0) {
            calendar.setTimeInMillis((long)p * 1000L + (long)s);
        } else {
            calendar.set(1, ((p &= Integer.MAX_VALUE) >>> 14 & 0xFFFF) + 1900);
            calendar.set(2, p >>> 10 & 0xF);
            calendar.set(5, p >>> 5 & 0x1F);
            calendar.set(11, p & 0x1F);
            calendar.set(12, s >>> 26 & 0x3F);
            calendar.set(13, s >>> 20 & 0x3F);
            calendar.set(14, s & 0xFFFFF);
        }
        time.setJavaCalendar(calendar);
        return time;
    }

    private RubyTime createTime(IRubyObject[] args, boolean gmt) {
        int len = 6;
        if (args.length == 10) {
            args = new IRubyObject[]{args[5], args[4], args[3], args[2], args[1], args[0]};
        } else {
            len = this.checkArgumentCount(args, 1, 7);
        }
        ThreadContext tc = this.getRuntime().getCurrentContext();
        if (!(args[0] instanceof RubyNumeric)) {
            args[0] = args[0].callMethod(tc, "to_i");
        }
        int year = (int)RubyNumeric.num2long(args[0]);
        int month = 0;
        if (len > 1) {
            if (!args[1].isNil()) {
                if (args[1] instanceof RubyString) {
                    month = -1;
                    for (int i = 0; i < 12; ++i) {
                        if (!months[i].equalsIgnoreCase(args[1].toString())) continue;
                        month = i;
                    }
                    if (month == -1) {
                        try {
                            month = Integer.parseInt(args[1].toString()) - 1;
                        }
                        catch (NumberFormatException nfExcptn) {
                            throw this.getRuntime().newArgumentError("Argument out of range.");
                        }
                    }
                } else {
                    month = (int)RubyNumeric.num2long(args[1]) - 1;
                }
            }
            if (0 > month || month > 11) {
                throw this.getRuntime().newArgumentError("Argument out of range.");
            }
        }
        int[] int_args = new int[]{1, 0, 0, 0, 0};
        int i = 0;
        while (len > i + 2) {
            if (!args[i + 2].isNil()) {
                if (!(args[i + 2] instanceof RubyNumeric)) {
                    args[i + 2] = args[i + 2].callMethod(tc, "to_i");
                }
                int_args[i] = (int)RubyNumeric.num2long(args[i + 2]);
                if (time_min[i] > (long)int_args[i] || (long)int_args[i] > time_max[i]) {
                    throw this.getRuntime().newArgumentError("Argument out of range.");
                }
            }
            ++i;
        }
        Calendar cal = gmt ? Calendar.getInstance(TimeZone.getTimeZone("UTC")) : Calendar.getInstance();
        RubyTime time = new RubyTime(this.getRuntime(), (RubyClass)this, cal);
        cal.set(year, month, int_args[0], int_args[1], int_args[2], int_args[3]);
        cal.set(14, int_args[4] / 1000);
        time.setUSec(int_args[4] % 1000);
        time.callInit(args);
        return time;
    }

    protected class TimeMeta
    extends AbstractMetaClass.Meta {
        protected TimeMeta() {
        }

        @Override
        protected void initializeClass() {
            TimeMetaClass.this.includeModule(TimeMetaClass.this.getRuntime().getModule("Comparable"));
            TimeMetaClass.this.defineSingletonMethod("new", Arity.noArguments(), "s_new");
            TimeMetaClass.this.defineSingletonMethod("now", Arity.noArguments(), "s_new");
            TimeMetaClass.this.defineSingletonMethod("at", Arity.optional(), "new_at");
            TimeMetaClass.this.defineSingletonMethod("local", Arity.optional(), "new_local");
            TimeMetaClass.this.defineSingletonMethod("mktime", Arity.optional(), "new_local");
            TimeMetaClass.this.defineSingletonMethod("utc", Arity.optional(), "new_utc");
            TimeMetaClass.this.defineSingletonMethod("gm", Arity.optional(), "new_utc");
            TimeMetaClass.this.defineSingletonMethod("_load", Arity.singleArgument(), "s_load");
            TimeMetaClass.this.defineMethod(">=", Arity.singleArgument(), "op_ge");
            TimeMetaClass.this.defineMethod(">", Arity.singleArgument(), "op_gt");
            TimeMetaClass.this.defineMethod("<=", Arity.singleArgument(), "op_le");
            TimeMetaClass.this.defineMethod("<", Arity.singleArgument(), "op_lt");
            TimeMetaClass.this.defineMethod("===", Arity.singleArgument(), "same2");
            TimeMetaClass.this.defineMethod("+", Arity.singleArgument(), "op_plus");
            TimeMetaClass.this.defineMethod("-", Arity.singleArgument(), "op_minus");
            TimeMetaClass.this.defineMethod("<=>", Arity.singleArgument(), "op_cmp");
            TimeMetaClass.this.defineMethod("asctime", Arity.noArguments());
            TimeMetaClass.this.defineMethod("mday", Arity.noArguments());
            TimeMetaClass.this.defineAlias("day", "mday");
            TimeMetaClass.this.defineAlias("ctime", "asctime");
            TimeMetaClass.this.defineMethod("sec", Arity.noArguments());
            TimeMetaClass.this.defineMethod("min", Arity.noArguments());
            TimeMetaClass.this.defineMethod("hour", Arity.noArguments());
            TimeMetaClass.this.defineMethod("month", Arity.noArguments());
            TimeMetaClass.this.defineAlias("mon", "month");
            TimeMetaClass.this.defineMethod("year", Arity.noArguments());
            TimeMetaClass.this.defineMethod("wday", Arity.noArguments());
            TimeMetaClass.this.defineMethod("yday", Arity.noArguments());
            TimeMetaClass.this.defineMethod("isdst", Arity.noArguments());
            TimeMetaClass.this.defineAlias("dst?", "isdst");
            TimeMetaClass.this.defineMethod("zone", Arity.noArguments());
            TimeMetaClass.this.defineMethod("to_a", Arity.noArguments());
            TimeMetaClass.this.defineMethod("to_f", Arity.noArguments());
            TimeMetaClass.this.defineMethod("to_i", Arity.noArguments());
            TimeMetaClass.this.defineMethod("to_s", Arity.noArguments());
            TimeMetaClass.this.defineMethod("inspect", Arity.noArguments());
            TimeMetaClass.this.defineMethod("strftime", Arity.singleArgument());
            TimeMetaClass.this.defineMethod("usec", Arity.noArguments());
            TimeMetaClass.this.defineAlias("tv_usec", "usec");
            TimeMetaClass.this.defineAlias("tv_sec", "to_i");
            TimeMetaClass.this.defineMethod("gmtime", Arity.noArguments());
            TimeMetaClass.this.defineAlias("utc", "gmtime");
            TimeMetaClass.this.defineMethod("gmt?", Arity.noArguments(), "gmt");
            TimeMetaClass.this.defineAlias("utc?", "gmt?");
            TimeMetaClass.this.defineAlias("gmtime?", "gmt?");
            TimeMetaClass.this.defineMethod("localtime", Arity.noArguments());
            TimeMetaClass.this.defineMethod("hash", Arity.noArguments());
            TimeMetaClass.this.defineMethod("initialize_copy", Arity.singleArgument());
            TimeMetaClass.this.defineMethod("_dump", Arity.optional(), "dump");
            TimeMetaClass.this.defineMethod("gmt_offset", Arity.noArguments());
            TimeMetaClass.this.defineAlias("gmtoff", "gmt_offset");
            TimeMetaClass.this.defineAlias("utc_offset", "gmt_offset");
            TimeMetaClass.this.defineMethod("getgm", Arity.noArguments());
            TimeMetaClass.this.defineMethod("getlocal", Arity.noArguments());
            TimeMetaClass.this.defineAlias("getutc", "getgm");
        }
    }
}

