/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.marshal;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.jruby.IRuby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.marshal.MarshalCache;

public class MarshalStream
extends FilterOutputStream {
    private final IRuby runtime;
    private final int depthLimit;
    private int depth = 0;
    private MarshalCache cache;
    private static final char TYPE_IVAR = 'I';
    private static final char TYPE_USRMARSHAL = 'U';
    private static final char TYPE_USERDEF = 'u';
    protected static char TYPE_UCLASS = (char)67;

    public MarshalStream(IRuby runtime, OutputStream out, int depthLimit) throws IOException {
        super(out);
        this.runtime = runtime;
        this.depthLimit = depthLimit >= 0 ? depthLimit : Integer.MAX_VALUE;
        this.cache = new MarshalCache();
        out.write(4);
        out.write(8);
    }

    public void dumpObject(IRubyObject value) throws IOException {
        ++this.depth;
        if (this.depth > this.depthLimit) {
            throw this.runtime.newArgumentError("exceed depth limit");
        }
        if (!this.shouldBeRegistered(value)) {
            this.writeDirectly(value);
        } else if (this.hasNewUserDefinedMarshaling(value)) {
            this.userNewMarshal(value);
        } else if (this.hasUserDefinedMarshaling(value)) {
            this.userMarshal(value);
        } else {
            this.writeAndRegister(value);
        }
        --this.depth;
        if (this.depth == 0) {
            this.out.flush();
        }
    }

    public void writeUserClass(IRubyObject obj, RubyClass baseClass, MarshalStream output) throws IOException {
        if (obj.getMetaClass().equals(baseClass)) {
            return;
        }
        output.write(TYPE_UCLASS);
        if (obj.getMetaClass().getName().charAt(0) == '#') {
            throw obj.getRuntime().newTypeError("Can't dump anonymous class");
        }
        output.dumpObject(RubySymbol.newSymbol(obj.getRuntime(), obj.getMetaClass().getName()));
    }

    public void writeInstanceVars(IRubyObject obj, MarshalStream output) throws IOException {
        IRuby runtime = obj.getRuntime();
        Map iVars = obj.getInstanceVariablesSnapshot();
        output.dumpInt(iVars.size());
        for (String name : iVars.keySet()) {
            IRubyObject value = (IRubyObject)iVars.get(name);
            output.dumpObject(runtime.newSymbol(name));
            output.dumpObject(value);
        }
    }

    private void writeDirectly(IRubyObject value) throws IOException {
        if (value.isNil()) {
            this.out.write(48);
        } else {
            value.marshalTo(this);
        }
    }

    private boolean shouldBeRegistered(IRubyObject value) {
        if (value.isNil()) {
            return false;
        }
        if (value instanceof RubyBoolean) {
            return false;
        }
        return !(value instanceof RubyFixnum);
    }

    private void writeAndRegister(IRubyObject value) throws IOException {
        if (this.cache.isRegistered(value)) {
            this.cache.writeLink(this, value);
        } else {
            this.cache.register(value);
            value.marshalTo(this);
        }
    }

    private boolean hasUserDefinedMarshaling(IRubyObject value) {
        return value.respondsTo("_dump");
    }

    private boolean hasNewUserDefinedMarshaling(IRubyObject value) {
        return value.respondsTo("marshal_dump");
    }

    private void userMarshal(IRubyObject value) throws IOException {
        this.out.write(117);
        this.dumpObject(RubySymbol.newSymbol(this.runtime, value.getMetaClass().getName()));
        RubyString marshaled = (RubyString)value.callMethod(this.runtime.getCurrentContext(), "_dump", this.runtime.newFixnum(this.depthLimit));
        this.dumpString(marshaled.toString());
    }

    private void userNewMarshal(IRubyObject value) throws IOException {
        this.out.write(85);
        this.dumpObject(RubySymbol.newSymbol(this.runtime, value.getMetaClass().getName()));
        IRubyObject marshaled = value.callMethod(this.runtime.getCurrentContext(), "marshal_dump");
        this.dumpObject(marshaled);
    }

    public void dumpString(String value) throws IOException {
        this.dumpInt(value.length());
        this.out.write(RubyString.stringToBytes(value));
    }

    public void dumpInt(int value) throws IOException {
        if (value == 0) {
            this.out.write(0);
        } else if (0 < value && value < 123) {
            this.out.write(value + 5);
        } else if (-124 < value && value < 0) {
            this.out.write(value - 5 & 0xFF);
        } else {
            int i;
            int[] buf = new int[4];
            for (i = 0; i < buf.length; ++i) {
                buf[i] = value & 0xFF;
                if ((value >>= 8) == 0 || value == -1) break;
            }
            int len = i + 1;
            this.out.write(value < 0 ? -len : len);
            for (i = 0; i < len; ++i) {
                this.out.write(buf[i]);
            }
        }
    }

    public void writeIVar(IRubyObject obj, MarshalStream output) throws IOException {
        if (obj.getInstanceVariables().size() > 0) {
            this.out.write(73);
        }
    }
}

