/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.jruby.util.GenericMap;

public class WeakIdentityHashMap
extends GenericMap
implements Map {
    private static final float DEFAULT_RATIO = 0.75f;
    private static final Object NULL_KEY = new Object();
    private ReferenceQueue queue = new ReferenceQueue();
    private Entry[] table;
    private int range;
    private float ratio;

    private static Object unmaskKey(Object key) {
        if (key == NULL_KEY) {
            return null;
        }
        return key;
    }

    private Object maskKey(Object key) {
        if (key == null) {
            return NULL_KEY;
        }
        return key;
    }

    private int index(int hash) {
        return (hash & 0x7FFFFFF) % this.range;
    }

    public WeakIdentityHashMap() {
        this.clear();
    }

    public WeakIdentityHashMap(int size) {
        this.clear(Math.max(3, Math.round((float)size / 0.75f)));
    }

    @Override
    public void clear() {
        this.clear(3);
    }

    void clear(int size) {
        this.range = size;
        this.size = 0;
        this.ratio = 0.75f;
        this.table = new Entry[this.range];
    }

    private void expunge() {
        Entry e;
        while ((e = (Entry)this.queue.poll()) != null) {
            this.removeEntry(e);
        }
    }

    public Object get(Object key) {
        Object masked_key = this.maskKey(key);
        int hash = this.keyHash(masked_key);
        return this.get(hash, masked_key);
    }

    private Object get(int hash, Object masked_key) {
        int idx = this.index(hash);
        Entry ent = this.table[idx];
        while (ent != null) {
            if (ent.sameKey(hash, masked_key)) {
                return ent.value;
            }
            ent = ent.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object key) {
        Object masked_key = this.maskKey(key);
        int hash = this.keyHash(masked_key);
        return this.containsKey(hash, masked_key);
    }

    private boolean containsKey(int hash, Object masked_key) {
        int idx = this.index(hash);
        Entry ent = this.table[idx];
        while (ent != null) {
            if (ent.sameKey(hash, masked_key)) {
                return true;
            }
            ent = ent.next;
        }
        return false;
    }

    public Object put(Object key, Object value) {
        Object masked_key = this.maskKey(key);
        int hash = this.keyHash(masked_key);
        return this.put(hash, masked_key, value);
    }

    private Object put(int hash, Object masked_key, Object value) {
        int idx = this.index(hash);
        Entry ent = this.table[idx];
        while (ent != null) {
            if (ent.sameKey(hash, masked_key)) {
                return ent.setValue(value);
            }
            ent = ent.next;
        }
        this.expunge();
        if (1.0f * (float)this.size / (float)this.range > this.ratio) {
            this.grow();
            idx = this.index(hash);
        }
        this.table[idx] = new Entry(hash, masked_key, value, this.table[idx], this.queue);
        ++this.size;
        return null;
    }

    public Object remove(Object key) {
        key = this.maskKey(key);
        int hash = this.keyHash(key);
        return this.remove(hash, key);
    }

    public Object remove(int hash, Object key) {
        key = this.maskKey(key);
        int idx = this.index(hash);
        Entry entry = this.table[idx];
        if (entry != null) {
            if (entry.sameKey(hash, key)) {
                this.table[idx] = entry.next;
                --this.size;
                return entry.getValue();
            }
            Entry ahead = entry.next;
            while (ahead != null) {
                if (ahead.sameKey(hash, key)) {
                    entry.next = ahead.next;
                    --this.size;
                    return ahead.getValue();
                }
                entry = ahead;
                ahead = ahead.next;
            }
        }
        return null;
    }

    private void removeEntry(Entry ent) {
        int idx = this.index(ent.key_hash);
        Entry entry = this.table[idx];
        if (entry != null) {
            if (entry == ent) {
                this.table[idx] = entry.next;
                --this.size;
                return;
            }
            Entry ahead = entry.next;
            while (ahead != null) {
                if (ahead == ent) {
                    entry.next = ahead.next;
                    --this.size;
                    return;
                }
                entry = ahead;
                ahead = ahead.next;
            }
        }
        this.valueRemoved(ent.value);
    }

    protected void valueRemoved(Object value) {
    }

    private void grow() {
        int old_range = this.range;
        Entry[] old_table = this.table;
        this.range = old_range * 2 + 1;
        this.table = new Entry[this.range];
        for (int i = 0; i < old_range; ++i) {
            Entry entry = old_table[i];
            while (entry != null) {
                Entry ahead = entry.next;
                int idx = this.index(entry.key_hash);
                entry.next = this.table[idx];
                this.table[idx] = entry;
                entry = ahead;
            }
        }
    }

    @Override
    protected Iterator entryIterator() {
        return new EntryIterator();
    }

    @Override
    protected final int keyHash(Object key) {
        return System.identityHashCode(key);
    }

    @Override
    protected final boolean keyEquals(Object key1, Object key2) {
        return key1 == key2;
    }

    @Override
    public int size() {
        this.expunge();
        return super.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    final class EntryIterator
    implements Iterator {
        int idx = 0;
        Entry entry;

        EntryIterator() {
            this.entry = WeakIdentityHashMap.this.table[0];
            this.locateNext();
        }

        private void locateNext() {
            while (this.entry == null) {
                ++this.idx;
                if (this.idx == WeakIdentityHashMap.this.range) {
                    return;
                }
                this.entry = WeakIdentityHashMap.this.table[this.idx];
            }
        }

        @Override
        public boolean hasNext() {
            return this.entry != null;
        }

        public Object next() {
            Entry result = this.entry;
            if (result == null) {
                throw new NoSuchElementException();
            }
            this.entry = this.entry.next;
            this.locateNext();
            return result;
        }

        @Override
        public void remove() {
            Entry remove = this.entry;
            this.entry = this.entry.next;
            this.locateNext();
            WeakIdentityHashMap.this.removeEntry(remove);
        }
    }

    class Entry
    extends WeakReference
    implements Map.Entry {
        Entry next;
        int key_hash;
        Object value;

        @Override
        public int hashCode() {
            return this.key_hash ^ WeakIdentityHashMap.this.valueHash(this.getValue());
        }

        @Override
        public boolean equals(Object other) {
            if (other instanceof Map.Entry) {
                Map.Entry ent = (Map.Entry)other;
                return this.getKey() == ent.getKey() && WeakIdentityHashMap.this.valueEquals(this.getValue(), ent.getValue());
            }
            return false;
        }

        Entry(int key_hash, Object masked_key, Object value, Entry next, ReferenceQueue q) {
            super(masked_key, q);
            this.key_hash = key_hash;
            this.value = value;
            this.next = next;
        }

        Object getMaskedKey() {
            return super.get();
        }

        public Object getKey() {
            return WeakIdentityHashMap.unmaskKey(this.getMaskedKey());
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object value) {
            Object result = this.value;
            this.value = value;
            return result;
        }

        boolean sameKey(int hash, Object masked_key) {
            return this.getMaskedKey() == masked_key;
        }
    }
}

