/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.Map;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;

public final class IncludedModuleWrapper
extends RubyClass {
    private RubyModule delegate;

    public IncludedModuleWrapper(IRuby runtime, RubyClass superClass, RubyModule delegate) {
        super(runtime, superClass);
        this.delegate = delegate;
    }

    @Override
    public IncludedModuleWrapper newIncludeClass(RubyClass superClass) {
        IncludedModuleWrapper includedModule = new IncludedModuleWrapper(this.getRuntime(), superClass, this.getNonIncludedClass());
        if (this.getSuperClass() != null) {
            includedModule.includeModule(this.getSuperClass());
        }
        return includedModule;
    }

    @Override
    public boolean isModule() {
        return false;
    }

    @Override
    public boolean isClass() {
        return false;
    }

    @Override
    public boolean isIncluded() {
        return true;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getMetaClass() {
        return this.delegate.getMetaClass();
    }

    @Override
    public void setMetaClass(RubyClass newRubyClass) {
        throw new UnsupportedOperationException("An included class is only a wrapper for a module");
    }

    @Override
    public Map getMethods() {
        return this.delegate.getMethods();
    }

    public void setMethods(Map newMethods) {
        throw new UnsupportedOperationException("An included class is only a wrapper for a module");
    }

    @Override
    public Map getInstanceVariables() {
        return this.delegate.getInstanceVariables();
    }

    @Override
    public void setInstanceVariables(Map newMethods) {
        throw new UnsupportedOperationException("An included class is only a wrapper for a module");
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    @Override
    public RubyModule getNonIncludedClass() {
        return this.delegate;
    }

    @Override
    public RubyClass getRealClass() {
        return this.getSuperClass().getRealClass();
    }

    @Override
    public boolean isSame(RubyModule module) {
        return this.delegate.isSame(module);
    }

    @Override
    public RubyFixnum id() {
        return this.delegate.id();
    }
}

