/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.jruby.IRuby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;

public class RubyDigest {
    public static void createDigest(IRuby runtime) {
        RubyModule mDigest = runtime.defineModule("Digest");
        RubyClass cDigestBase = mDigest.defineClassUnder("Base", runtime.getObject());
        CallbackFactory basecb = runtime.callbackFactory(Base.class);
        cDigestBase.defineSingletonMethod("new", basecb.getOptSingletonMethod("newInstance"));
        cDigestBase.defineSingletonMethod("digest", basecb.getSingletonMethod("s_digest", RubyString.class));
        cDigestBase.defineSingletonMethod("hexdigest", basecb.getSingletonMethod("s_hexdigest", RubyString.class));
        cDigestBase.defineMethod("initialize", basecb.getOptMethod("initialize"));
        cDigestBase.defineMethod("initialize_copy", basecb.getMethod("initialize_copy", IRubyObject.class));
        cDigestBase.defineMethod("clone", basecb.getMethod("rbClone"));
        cDigestBase.defineMethod("update", basecb.getMethod("update", IRubyObject.class));
        cDigestBase.defineMethod("<<", basecb.getMethod("update", IRubyObject.class));
        cDigestBase.defineMethod("digest", basecb.getMethod("digest"));
        cDigestBase.defineMethod("hexdigest", basecb.getMethod("hexdigest"));
        cDigestBase.defineMethod("to_s", basecb.getMethod("hexdigest"));
        cDigestBase.defineMethod("==", basecb.getMethod("eq", IRubyObject.class));
    }

    public static void createDigestMD5(IRuby runtime) {
        runtime.getModule("Kernel").callMethod(runtime.getCurrentContext(), "require", runtime.newString("digest.so"));
        RubyModule mDigest = runtime.getModule("Digest");
        RubyClass cDigestBase = mDigest.getClass("Base");
        RubyClass cDigest_MD5 = mDigest.defineClassUnder("MD5", cDigestBase);
        cDigest_MD5.setClassVar("metadata", runtime.newString("MD5"));
    }

    public static void createDigestRMD160(IRuby runtime) {
        runtime.getModule("Kernel").callMethod(runtime.getCurrentContext(), "require", runtime.newString("digest.so"));
        RubyModule mDigest = runtime.getModule("Digest");
        RubyClass cDigestBase = mDigest.getClass("Base");
        RubyClass cDigest_RMD160 = mDigest.defineClassUnder("RMD160", cDigestBase);
        cDigest_RMD160.setClassVar("metadata", runtime.newString("RIPEMD160"));
    }

    public static void createDigestSHA1(IRuby runtime) {
        runtime.getModule("Kernel").callMethod(runtime.getCurrentContext(), "require", runtime.newString("digest.so"));
        RubyModule mDigest = runtime.getModule("Digest");
        RubyClass cDigestBase = mDigest.getClass("Base");
        RubyClass cDigest_SHA1 = mDigest.defineClassUnder("SHA1", cDigestBase);
        cDigest_SHA1.setClassVar("metadata", runtime.newString("SHA1"));
    }

    public static void createDigestSHA2(IRuby runtime) {
        try {
            MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw runtime.newLoadError("SHA2 not supported");
        }
        runtime.getModule("Kernel").callMethod(runtime.getCurrentContext(), "require", runtime.newString("digest.so"));
        RubyModule mDigest = runtime.getModule("Digest");
        RubyClass cDigestBase = mDigest.getClass("Base");
        RubyClass cDigest_SHA2_256 = mDigest.defineClassUnder("SHA256", cDigestBase);
        cDigest_SHA2_256.setClassVar("metadata", runtime.newString("SHA-256"));
        RubyClass cDigest_SHA2_384 = mDigest.defineClassUnder("SHA384", cDigestBase);
        cDigest_SHA2_384.setClassVar("metadata", runtime.newString("SHA-384"));
        RubyClass cDigest_SHA2_512 = mDigest.defineClassUnder("SHA512", cDigestBase);
        cDigest_SHA2_512.setClassVar("metadata", runtime.newString("SHA-512"));
    }

    public static class Base
    extends RubyObject {
        private MessageDigest algo;
        private StringBuffer data = new StringBuffer();

        public static IRubyObject newInstance(IRubyObject recv, IRubyObject[] args) {
            if (recv == recv.getRuntime().getModule("Digest").getClass("Base")) {
                throw recv.getRuntime().newNotImplementedError("Digest::Base is an abstract class");
            }
            if (!((RubyClass)recv).isClassVarDefined("metadata")) {
                throw recv.getRuntime().newNotImplementedError("the " + recv + "() function is unimplemented on this machine");
            }
            Base result = new Base(recv.getRuntime(), (RubyClass)recv);
            try {
                result.setAlgorithm(((RubyClass)recv).getClassVar("metadata"));
            }
            catch (NoSuchAlgorithmException e) {
                throw recv.getRuntime().newNotImplementedError("the " + recv + "() function is unimplemented on this machine");
            }
            result.callInit(args);
            return result;
        }

        public static IRubyObject s_digest(IRubyObject recv, RubyString str) {
            String name = ((RubyClass)recv).getClassVar("metadata").toString();
            try {
                MessageDigest md = MessageDigest.getInstance(name);
                return recv.getRuntime().newString(new String(md.digest(str.toString().getBytes("PLAIN")), "ISO8859_1"));
            }
            catch (NoSuchAlgorithmException e) {
                throw recv.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + name + ")");
            }
            catch (UnsupportedEncodingException e) {
                throw recv.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + name + ")");
            }
        }

        public static IRubyObject s_hexdigest(IRubyObject recv, RubyString str) {
            String name = ((RubyClass)recv).getClassVar("metadata").toString();
            try {
                MessageDigest md = MessageDigest.getInstance(name);
                return recv.getRuntime().newString(Base.toHex(md.digest(str.toString().getBytes("PLAIN"))));
            }
            catch (NoSuchAlgorithmException e) {
                throw recv.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + name + ")");
            }
            catch (UnsupportedEncodingException e) {
                throw recv.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + name + ")");
            }
        }

        public Base(IRuby runtime, RubyClass type) {
            super(runtime, type);
        }

        @Override
        public IRubyObject initialize(IRubyObject[] args) {
            if (args.length > 0 && !args[0].isNil()) {
                this.update(args[0]);
            }
            return this;
        }

        @Override
        public IRubyObject initialize_copy(IRubyObject obj) {
            if (this == obj) {
                return this;
            }
            ((RubyObject)obj).checkFrozen();
            this.data = new StringBuffer(((Base)obj).data.toString());
            String name = ((Base)obj).algo.getAlgorithm();
            try {
                this.algo = MessageDigest.getInstance(name);
            }
            catch (NoSuchAlgorithmException e) {
                throw this.getRuntime().newNotImplementedError("Unsupported digest algorithm (" + name + ")");
            }
            return this;
        }

        public IRubyObject update(IRubyObject obj) {
            try {
                this.data.append(obj);
                this.algo.update(obj.toString().getBytes("PLAIN"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            return this;
        }

        public IRubyObject digest() {
            try {
                this.algo.reset();
                return this.getRuntime().newString(new String(this.algo.digest(this.data.toString().getBytes("PLAIN")), "ISO8859_1"));
            }
            catch (UnsupportedEncodingException e) {
                return this.getRuntime().getNil();
            }
        }

        public IRubyObject hexdigest() {
            try {
                this.algo.reset();
                return this.getRuntime().newString(Base.toHex(this.algo.digest(this.data.toString().getBytes("PLAIN"))));
            }
            catch (UnsupportedEncodingException e) {
                return this.getRuntime().getNil();
            }
        }

        public IRubyObject eq(IRubyObject oth) {
            boolean ret;
            boolean bl = ret = this == oth;
            if (!ret && oth instanceof Base) {
                Base b = (Base)oth;
                ret = this.algo.getAlgorithm().equals(b.algo.getAlgorithm()) && this.digest().equals(b.digest());
            }
            return ret ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @Override
        public IRubyObject rbClone() {
            Base clone = new Base(this.getRuntime(), this.getMetaClass().getRealClass());
            clone.setMetaClass(this.getMetaClass().getSingletonClassClone());
            clone.setTaint(this.isTaint());
            clone.initCopy(this);
            clone.setFrozen(this.isFrozen());
            return clone;
        }

        private void setAlgorithm(IRubyObject algo) throws NoSuchAlgorithmException {
            this.algo = MessageDigest.getInstance(algo.toString());
        }

        private static String toHex(byte[] val) {
            StringBuffer out = new StringBuffer();
            int j = val.length;
            for (int i = 0; i < j; ++i) {
                String ve = Integer.toString((char)val[i] & 0xFF, 16);
                if (ve.length() == 1) {
                    ve = "0" + ve;
                }
                out.append(ve);
            }
            return out.toString();
        }
    }
}

