/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.RubyTime;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyFile;

public class RubyFileStat
extends RubyObject {
    private static final int READ = 222;
    private static final int WRITE = 444;
    private RubyFixnum blksize;
    private RubyBoolean isDirectory;
    private RubyBoolean isFile;
    private RubyString ftype;
    private RubyFixnum mode;
    private RubyTime mtime;
    private RubyBoolean isReadable;
    private RubyBoolean isWritable;
    private RubyFixnum size;
    private RubyBoolean isSymlink;

    public static RubyClass createFileStatClass(IRuby runtime) {
        RubyClass fileStatClass = runtime.getClass("File").defineClassUnder("Stat", runtime.getObject());
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyFileStat.class);
        fileStatClass.defineMethod("blksize", callbackFactory.getMethod("blksize"));
        fileStatClass.defineMethod("directory?", callbackFactory.getMethod("directory_p"));
        fileStatClass.defineMethod("file?", callbackFactory.getMethod("file_p"));
        fileStatClass.defineMethod("ftype", callbackFactory.getMethod("ftype"));
        fileStatClass.defineMethod("ino", callbackFactory.getMethod("ino"));
        fileStatClass.defineMethod("mode", callbackFactory.getMethod("mode"));
        fileStatClass.defineMethod("mtime", callbackFactory.getMethod("mtime"));
        fileStatClass.defineMethod("readable?", callbackFactory.getMethod("readable_p"));
        fileStatClass.defineMethod("size", callbackFactory.getMethod("size"));
        fileStatClass.defineMethod("symlink?", callbackFactory.getMethod("symlink_p"));
        fileStatClass.defineMethod("writable?", callbackFactory.getMethod("writable"));
        return fileStatClass;
    }

    protected RubyFileStat(IRuby runtime, JRubyFile file) {
        super(runtime, runtime.getClass("File").getClass("Stat"));
        if (!file.exists()) {
            throw runtime.newErrnoENOENTError("No such file or directory - " + file.getPath());
        }
        this.blksize = runtime.newFixnum(4096L);
        this.isDirectory = runtime.newBoolean(file.isDirectory());
        this.isFile = runtime.newBoolean(file.isFile());
        this.ftype = file.isDirectory() ? runtime.newString("directory") : (file.isFile() ? runtime.newString("file") : null);
        int baseMode = 32768;
        if (file.canRead()) {
            baseMode += 222;
        }
        if (file.canWrite()) {
            baseMode += 444;
        }
        this.mode = runtime.newFixnum(baseMode);
        this.mtime = runtime.newTime(file.lastModified());
        this.isReadable = runtime.newBoolean(file.canRead());
        this.isWritable = runtime.newBoolean(file.canWrite());
        this.size = runtime.newFixnum(file.length());
        this.isSymlink = runtime.getFalse();
    }

    public RubyFixnum blksize() {
        return this.blksize;
    }

    public RubyBoolean directory_p() {
        return this.isDirectory;
    }

    public RubyBoolean file_p() {
        return this.isFile;
    }

    public RubyString ftype() {
        return this.ftype;
    }

    public IRubyObject ino() {
        return this.getRuntime().newFixnum(0L);
    }

    public IRubyObject mode() {
        return this.mode;
    }

    public IRubyObject mtime() {
        return this.mtime;
    }

    public IRubyObject readable_p() {
        return this.isReadable;
    }

    public IRubyObject size() {
        return this.size;
    }

    public IRubyObject symlink_p() {
        return this.isSymlink;
    }

    public IRubyObject writable() {
        return this.isWritable;
    }
}

