/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jruby.IRuby;
import org.jruby.RubyBoolean;
import org.jruby.RubyModule;
import org.jruby.runtime.CallbackFactory;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyFile;

public class RubyFileTest {
    public static RubyModule createFileTestModule(IRuby runtime) {
        RubyModule fileTestModule = runtime.defineModule("FileTest");
        CallbackFactory callbackFactory = runtime.callbackFactory(RubyFileTest.class);
        fileTestModule.defineSingletonMethod("file?", callbackFactory.getSingletonMethod("file_p", IRubyObject.class));
        fileTestModule.defineSingletonMethod("directory?", callbackFactory.getSingletonMethod("directory_p", IRubyObject.class));
        fileTestModule.defineSingletonMethod("exist?", callbackFactory.getSingletonMethod("exist_p", IRubyObject.class));
        fileTestModule.defineSingletonMethod("exists?", callbackFactory.getSingletonMethod("exist_p", IRubyObject.class));
        fileTestModule.defineSingletonMethod("readable?", callbackFactory.getSingletonMethod("readable_p", IRubyObject.class));
        fileTestModule.defineSingletonMethod("readable_real?", callbackFactory.getSingletonMethod("readable_p", IRubyObject.class));
        fileTestModule.defineSingletonMethod("size", callbackFactory.getSingletonMethod("size", IRubyObject.class));
        fileTestModule.defineSingletonMethod("writable?", callbackFactory.getSingletonMethod("writable_p", IRubyObject.class));
        fileTestModule.defineSingletonMethod("writable_real?", callbackFactory.getSingletonMethod("writable_p", IRubyObject.class));
        fileTestModule.defineSingletonMethod("zero?", callbackFactory.getSingletonMethod("zero_p", IRubyObject.class));
        fileTestModule.defineMethod("file?", callbackFactory.getSingletonMethod("file_p", IRubyObject.class));
        fileTestModule.defineMethod("directory?", callbackFactory.getSingletonMethod("directory_p", IRubyObject.class));
        fileTestModule.defineMethod("exist?", callbackFactory.getSingletonMethod("exist_p", IRubyObject.class));
        fileTestModule.defineMethod("exists?", callbackFactory.getSingletonMethod("exist_p", IRubyObject.class));
        fileTestModule.defineMethod("readable?", callbackFactory.getSingletonMethod("readable_p", IRubyObject.class));
        fileTestModule.defineMethod("readable_real?", callbackFactory.getSingletonMethod("readable_p", IRubyObject.class));
        fileTestModule.defineMethod("size", callbackFactory.getSingletonMethod("size", IRubyObject.class));
        fileTestModule.defineMethod("writable?", callbackFactory.getSingletonMethod("writable_p", IRubyObject.class));
        fileTestModule.defineMethod("writable_real?", callbackFactory.getSingletonMethod("writable_p", IRubyObject.class));
        fileTestModule.defineMethod("zero?", callbackFactory.getSingletonMethod("zero_p", IRubyObject.class));
        return fileTestModule;
    }

    public static RubyBoolean directory_p(IRubyObject recv, IRubyObject filename) {
        return recv.getRuntime().newBoolean(RubyFileTest.newFile(filename).isDirectory());
    }

    public static IRubyObject exist_p(IRubyObject recv, IRubyObject filename) {
        return recv.getRuntime().newBoolean(RubyFileTest.newFile(filename).exists());
    }

    public static RubyBoolean readable_p(IRubyObject recv, IRubyObject filename) {
        return filename.getRuntime().newBoolean(RubyFileTest.newFile(filename).canRead());
    }

    public static IRubyObject size(IRubyObject recv, IRubyObject filename) {
        JRubyFile file = RubyFileTest.newFile(filename);
        if (!file.exists()) {
            throw recv.getRuntime().newErrnoENOENTError("No such file: " + filename);
        }
        return filename.getRuntime().newFixnum(file.length());
    }

    public static RubyBoolean writable_p(IRubyObject recv, IRubyObject filename) {
        return filename.getRuntime().newBoolean(RubyFileTest.newFile(filename).canWrite());
    }

    public static RubyBoolean zero_p(IRubyObject recv, IRubyObject filename) {
        JRubyFile file = RubyFileTest.newFile(filename);
        return filename.getRuntime().newBoolean(file.exists() && file.length() == 0L);
    }

    public static RubyBoolean file_p(IRubyObject recv, IRubyObject filename) {
        JRubyFile file = RubyFileTest.newFile(filename);
        return filename.getRuntime().newBoolean(file.isFile());
    }

    private static JRubyFile newFile(IRubyObject path) {
        return JRubyFile.create(path.getRuntime().getCurrentDirectory(), path.convertToString().toString());
    }
}

